/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.readhandlers;

import org.jfree.report.Element;
import org.jfree.report.filter.DataSource;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.ext.readhandlers.DataSourceReadHandler;
import org.jfree.report.modules.parser.ext.readhandlers.StyleReadHandler;
import org.jfree.report.modules.parser.ext.readhandlers.TemplateReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class ElementReadHandler
extends AbstractPropertyXmlReadHandler {
    private XmlReadHandler dataSourceHandler;
    private Element element;

    public ElementReadHandler(Element element) {
        if (element == null) {
            throw new NullPointerException("Element given must not be null.");
        }
        this.element = element;
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        if (this.dataSourceHandler != null) {
            this.element.setDataSource((DataSource)this.dataSourceHandler.getObject());
        }
    }

    protected Element getElement() {
        return this.element;
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals("style")) {
            return new StyleReadHandler(this.element.getStyle());
        }
        if (tagName.equals("datasource")) {
            CommentHintPath hintPath = new CommentHintPath(this.element);
            hintPath.addName("datasource");
            this.dataSourceHandler = new DataSourceReadHandler(hintPath);
            return this.dataSourceHandler;
        }
        if (tagName.equals("template")) {
            CommentHintPath hintPath = new CommentHintPath(this.element);
            hintPath.addName("template");
            this.dataSourceHandler = new TemplateReadHandler(false, hintPath);
            return this.dataSourceHandler;
        }
        return null;
    }

    public Object getObject() throws XmlReaderException {
        return this.element;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        String name = attrs.getValue("name");
        if (name != null) {
            this.element.setName(name);
        }
    }

    protected void storeComments() throws SAXException {
        this.defaultStoreComments(new CommentHintPath(this.element));
    }
}

