/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.factory.objects;

import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class FontDefinitionObjectDescription
extends AbstractObjectDescription {
    public static final String FONT_ENCODING = "fontEncoding";
    public static final String FONT_NAME = "fontName";
    public static final String FONT_SIZE = "fontSize";
    public static final String BOLD = "bold";
    public static final String EMBEDDED_FONT = "embeddedFont";
    public static final String ITALIC = "italic";
    public static final String STRIKETHROUGH = "strikethrough";
    public static final String UNDERLINE = "underline";
    static /* synthetic */ Class class$org$jfree$report$style$FontDefinition;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public FontDefinitionObjectDescription() {
        super(class$org$jfree$report$style$FontDefinition != null ? class$org$jfree$report$style$FontDefinition : (class$org$jfree$report$style$FontDefinition = FontDefinitionObjectDescription.class$("org.jfree.report.style.FontDefinition")));
        this.setParameterDefinition(FONT_ENCODING, class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = FontDefinitionObjectDescription.class$("java.lang.String")));
        this.setParameterDefinition(FONT_NAME, class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = FontDefinitionObjectDescription.class$("java.lang.String")));
        this.setParameterDefinition(FONT_SIZE, class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = FontDefinitionObjectDescription.class$("java.lang.Integer")));
        this.setParameterDefinition(BOLD, class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = FontDefinitionObjectDescription.class$("java.lang.Boolean")));
        this.setParameterDefinition(EMBEDDED_FONT, class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = FontDefinitionObjectDescription.class$("java.lang.Boolean")));
        this.setParameterDefinition(ITALIC, class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = FontDefinitionObjectDescription.class$("java.lang.Boolean")));
        this.setParameterDefinition(STRIKETHROUGH, class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = FontDefinitionObjectDescription.class$("java.lang.Boolean")));
        this.setParameterDefinition(UNDERLINE, class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = FontDefinitionObjectDescription.class$("java.lang.Boolean")));
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object createObject() {
        try {
            String fontEncoding = (String)this.getParameter(FONT_ENCODING);
            String fontName = (String)this.getParameter(FONT_NAME);
            int fontSize = this.getIntegerParameter(FONT_SIZE);
            boolean bold = this.getBooleanParameter(BOLD);
            boolean embedded = this.getBooleanParameter(EMBEDDED_FONT);
            boolean italic = this.getBooleanParameter(ITALIC);
            boolean strike = this.getBooleanParameter(STRIKETHROUGH);
            boolean underline = this.getBooleanParameter(UNDERLINE);
            return new FontDefinition(fontName, fontSize, bold, italic, underline, strike, fontEncoding, embedded);
        }
        catch (Exception e) {
            Log.info("Failed to create FontDefinition: ", e);
            return null;
        }
    }

    private Boolean getBoolean(boolean bool) {
        if (bool) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean getBooleanParameter(String name) {
        Boolean bool = (Boolean)this.getParameter(name);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    private int getIntegerParameter(String name) throws ObjectFactoryException {
        Integer i = (Integer)this.getParameter(name);
        if (i == null) {
            throw new ObjectFactoryException("Parameter " + name + " is not set");
        }
        return i;
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof FontDefinition)) {
            throw new ObjectFactoryException("The given object is no FontDefinition.");
        }
        FontDefinition fdef = (FontDefinition)o;
        this.setParameter(FONT_ENCODING, fdef.getFontEncoding(null));
        this.setParameter(FONT_NAME, fdef.getFontName());
        this.setParameter(FONT_SIZE, new Integer(fdef.getFontSize()));
        this.setParameter(BOLD, this.getBoolean(fdef.isBold()));
        this.setParameter(EMBEDDED_FONT, this.getBoolean(fdef.isEmbeddedFont()));
        this.setParameter(ITALIC, this.getBoolean(fdef.isItalic()));
        this.setParameter(STRIKETHROUGH, this.getBoolean(fdef.isStrikeThrough()));
        this.setParameter(UNDERLINE, this.getBoolean(fdef.isUnderline()));
    }
}

