/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.factory.datasource;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.report.modules.parser.ext.factory.datasource.DataSourceFactory;
import org.jfree.util.ClassComparator;
import org.jfree.util.Configuration;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.ObjectDescription;

public class DataSourceCollector
implements DataSourceFactory,
Serializable {
    private final ArrayList factories = new ArrayList();
    private final ClassComparator comparator = new ClassComparator();
    private Configuration config;

    public void addFactory(DataSourceFactory factory) {
        this.factories.add(factory);
        if (this.getConfig() != null) {
            factory.configure(this.getConfig());
        }
    }

    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        if (this.config != null) {
            return;
        }
        this.config = config;
        Iterator it = ((AbstractList)this.factories).iterator();
        while (it.hasNext()) {
            DataSourceFactory od = (DataSourceFactory)it.next();
            od.configure(config);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ObjectDescription getDataSourceDescription(String name) {
        int i = 0;
        while (i < this.factories.size()) {
            DataSourceFactory fact = (DataSourceFactory)this.factories.get(i);
            ObjectDescription o = fact.getDataSourceDescription(name);
            if (o != null) {
                return o.getInstance();
            }
            ++i;
        }
        return null;
    }

    public String getDataSourceName(ObjectDescription od) {
        int i = 0;
        while (i < this.factories.size()) {
            DataSourceFactory fact = (DataSourceFactory)this.factories.get(i);
            String o = fact.getDataSourceName(od);
            if (o != null) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public ObjectDescription getDescriptionForClass(Class c) {
        int i = 0;
        while (i < this.factories.size()) {
            DataSourceFactory fact = (DataSourceFactory)this.factories.get(i);
            ObjectDescription o = fact.getDescriptionForClass(c);
            if (o != null) {
                return o.getInstance();
            }
            ++i;
        }
        return null;
    }

    public Iterator getFactories() {
        return ((AbstractList)this.factories).iterator();
    }

    public Iterator getRegisteredClasses() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.factories.size()) {
            ClassFactory f = (ClassFactory)this.factories.get(i);
            Iterator keys = f.getRegisteredClasses();
            while (keys.hasNext()) {
                list.add(keys.next());
            }
            ++i;
        }
        return ((AbstractList)list).iterator();
    }

    public Iterator getRegisteredNames() {
        return ((AbstractList)new ArrayList()).iterator();
    }

    public ObjectDescription getSuperClassObjectDescription(Class d, ObjectDescription knownSuperClass) {
        int i = 0;
        while (i < this.factories.size()) {
            DataSourceFactory fact = (DataSourceFactory)this.factories.get(i);
            ObjectDescription od = fact.getSuperClassObjectDescription(d, knownSuperClass);
            if (od != null) {
                if (knownSuperClass == null) {
                    knownSuperClass = od;
                } else if (this.comparator.isComparable(knownSuperClass.getObjectClass(), od.getObjectClass()) && this.comparator.compare((Object)knownSuperClass.getObjectClass(), (Object)od.getObjectClass()) < 0) {
                    knownSuperClass = od;
                }
            }
            ++i;
        }
        if (knownSuperClass != null) {
            return knownSuperClass.getInstance();
        }
        return null;
    }
}

