/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.base.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.PropertyStringReadHandler;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class ConfigurationReadHandler
extends AbstractPropertyXmlReadHandler {
    private ReportConfiguration configuration;
    private HashMap fieldHandlers;

    public ConfigurationReadHandler(ReportConfiguration configuration) {
        this.configuration = configuration;
        this.fieldHandlers = new HashMap();
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        Iterator it = this.fieldHandlers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            PropertyStringReadHandler readHandler = (PropertyStringReadHandler)((Object)entry.getValue());
            this.configuration.setConfigProperty(key, readHandler.getResult());
        }
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals("property")) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ElementDefinitionException("Required attribute 'name' is missing.");
            }
            CommentHintPath path = new CommentHintPath("report-definition");
            path.addName("report-config");
            path.addName("configuration");
            PropertyStringReadHandler readHandler = new PropertyStringReadHandler(path);
            this.fieldHandlers.put(name, readHandler);
            return readHandler;
        }
        return null;
    }

    public Object getObject() throws XmlReaderException {
        return this.configuration;
    }

    protected void storeComments() throws SAXException {
        CommentHintPath path = new CommentHintPath((Object)this.configuration);
        this.defaultStoreComments(path);
    }
}

