/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.base;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.parser.base.ParserEntityResolver;
import org.jfree.report.modules.parser.base.ReportParser;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.FrontendDefaultHandler;
import org.jfree.xml.ParserFrontend;
import org.jfree.xml.parser.RootXmlReadHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ReportGenerator
extends ParserFrontend {
    public static final String PARSER_VALIDATE = "org.jfree.report.modules.parser.base.Validate";
    public static final String PARSER_VALIDATE_DEFAULT = "true";
    private static ReportGenerator generator;
    private HashMap helperObjects;

    protected ReportGenerator() {
        super((FrontendDefaultHandler)new ReportParser());
        this.initFromSystem();
        this.helperObjects = new HashMap();
    }

    protected void configureReader(XMLReader reader, FrontendDefaultHandler handler) {
        super.configureReader(reader, handler);
        if (handler instanceof RootXmlReadHandler) {
            RootXmlReadHandler readHandler = (RootXmlReadHandler)handler;
            Iterator helperObjectsIterator = this.helperObjects.entrySet().iterator();
            while (helperObjectsIterator.hasNext()) {
                Map.Entry entry = helperObjectsIterator.next();
                readHandler.setHelperObject((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public static ReportGenerator createInstance() {
        return new ReportGenerator();
    }

    public static synchronized ReportGenerator getInstance() {
        if (generator == null) {
            generator = new ReportGenerator();
        }
        return generator;
    }

    public Object getObject(String key) {
        return this.helperObjects.get(key);
    }

    public void initFromSystem() {
        this.setEntityResolver(ParserEntityResolver.getDefaultResolver());
    }

    public boolean isValidateDTD() {
        return ReportConfiguration.getGlobalConfig().getConfigProperty(PARSER_VALIDATE, PARSER_VALIDATE_DEFAULT).equalsIgnoreCase(PARSER_VALIDATE_DEFAULT);
    }

    public JFreeReport parseReport(File file) throws IOException, ElementDefinitionException {
        if (file == null) {
            throw new NullPointerException();
        }
        File contentBase = file.getCanonicalFile().getParentFile();
        return this.parseReport(file.toURL(), contentBase.toURL());
    }

    public JFreeReport parseReport(String file) throws IOException, ElementDefinitionException {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        return this.parseReport(new File(file));
    }

    public JFreeReport parseReport(URL file) throws ElementDefinitionException, IOException {
        return this.parseReport(file, file);
    }

    public JFreeReport parseReport(URL file, URL contentBase) throws ElementDefinitionException, IOException {
        JFreeReport report = (JFreeReport)this.parse(file, contentBase);
        report.setProperty("report.definition.source", file.toString());
        if (contentBase != null) {
            report.setProperty("report.definition.contentbase", contentBase.toString());
        } else {
            report.setProperty("report.definition.contentbase", file.toString());
        }
        return report;
    }

    public JFreeReport parseReport(InputSource input, URL contentBase) throws ElementDefinitionException {
        return (JFreeReport)super.parse(input, contentBase);
    }

    public void setObject(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.helperObjects.remove(key);
        } else {
            this.helperObjects.put(key, value);
        }
    }

    public void setValidateDTD(boolean validate) {
        ReportConfiguration.getGlobalConfig().setConfigProperty(PARSER_VALIDATE, String.valueOf(validate));
    }
}

