/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls.util;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import org.apache.poi.hssf.util.HSSFColor;
import org.jfree.report.util.Log;

public final class ExcelColorSupport {
    private static Hashtable triplets;

    private ExcelColorSupport() {
    }

    public static short getNearestColor(Color awtColor) {
        short color = 8;
        if (triplets == null) {
            triplets = HSSFColor.getTripletHash();
        }
        if (triplets == null) {
            Log.warn("Unable to get triplet hashtable");
            return color;
        }
        Set keys = triplets.keySet();
        if (keys != null && keys.size() > 0) {
            long minDiff = Long.MAX_VALUE;
            int colorValue = awtColor.getRGB() & 0xFFFFFF;
            int cdRG = awtColor.getRed() - awtColor.getGreen();
            int cdGB = awtColor.getGreen() - awtColor.getBlue();
            int cdBR = awtColor.getBlue() - awtColor.getRed();
            Enumeration elements = triplets.elements();
            while (elements.hasMoreElements()) {
                HSSFColor crtColor = (HSSFColor)elements.nextElement();
                short[] rgb = crtColor.getTriplet();
                int xlRG = rgb[0] - rgb[1];
                int xlGB = rgb[1] - rgb[2];
                int xlBR = rgb[2] - rgb[0];
                int deltaRG = Math.abs(xlRG - cdRG);
                int deltaGB = Math.abs(xlGB - cdGB);
                int deltaBR = Math.abs(xlBR - cdBR);
                long delta = deltaBR + deltaGB + deltaRG;
                long excelColor = (delta << 24) + (long)(rgb[0] << 16) + (long)(rgb[1] << 8) + (long)rgb[2];
                long diff = Math.abs((long)colorValue - excelColor);
                if (diff >= minDiff) continue;
                minDiff = diff;
                if (minDiff == 0L) {
                    return crtColor.getIndex();
                }
                color = crtColor.getIndex();
            }
        }
        return color;
    }
}

