/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.report.Element;
import org.jfree.report.content.AnchorContentFactoryModule;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.DefaultContentFactory;
import org.jfree.report.content.ShapeContentFactoryModule;
import org.jfree.report.content.TextContentFactoryModule;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.DataTarget;
import org.jfree.report.filter.DateFormatFilter;
import org.jfree.report.filter.FormatFilter;
import org.jfree.report.filter.NumberFormatFilter;
import org.jfree.report.filter.RawDataSource;
import org.jfree.report.filter.templates.DateFieldTemplate;
import org.jfree.report.filter.templates.NumberFieldTemplate;
import org.jfree.report.layout.DefaultLayoutSupport;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.RawContent;
import org.jfree.report.modules.output.table.base.TableMetaBandProducer;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelDateMetaElement;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelMetaElement;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelNumberMetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictBounds;

public class ExcelMetaBandProducer
extends TableMetaBandProducer {
    private boolean defineDataFormats;

    public ExcelMetaBandProducer(boolean defineDataFormats) {
        super(new DefaultLayoutSupport(ExcelMetaBandProducer.createExcelContentFactory()));
        this.defineDataFormats = defineDataFormats;
    }

    private MetaElement createDateCell(Element e, long x, long y) {
        RawDataSource dft = (RawDataSource)e.getDataSource();
        Date date = (Date)dft.getRawValue();
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        ElementStyleSheet styleSheet = this.createStyleForTextElement(e, x, y);
        styleSheet.setStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, e.getStyle().getStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, this.getFormatString(dft)));
        return new ExcelDateMetaElement(new RawContent(rect, date), styleSheet);
    }

    protected MetaElement createDrawableCell(Element e, long x, long y) {
        return null;
    }

    private static ContentFactory createExcelContentFactory() {
        DefaultContentFactory contentFactory = new DefaultContentFactory();
        contentFactory.addModule(new TextContentFactoryModule());
        contentFactory.addModule(new ShapeContentFactoryModule());
        contentFactory.addModule(new AnchorContentFactoryModule());
        return contentFactory;
    }

    protected MetaElement createImageCell(Element e, long x, long y) {
        return null;
    }

    private MetaElement createNumberCell(Element e, long x, long y) {
        RawDataSource nft = (RawDataSource)e.getDataSource();
        Number number = (Number)nft.getRawValue();
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        ElementStyleSheet styleSheet = this.createStyleForTextElement(e, x, y);
        styleSheet.setStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, e.getStyle().getStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, this.getFormatString(nft)));
        return new ExcelNumberMetaElement(new RawContent(rect, number), styleSheet);
    }

    protected MetaElement createTextCell(Element e, long x, long y) {
        Object o = e.getValue();
        if (o == null) {
            return null;
        }
        DataSource template = e.getDataSource();
        if (template instanceof RawDataSource) {
            RawDataSource rawSource = (RawDataSource)template;
            Object rawValue = rawSource.getRawValue();
            if (rawValue instanceof Date) {
                return this.createDateCell(e, x, y);
            }
            if (rawValue instanceof Number) {
                return this.createNumberCell(e, x, y);
            }
        }
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        return new ExcelMetaElement(new RawContent(rect, String.valueOf(o)), this.createStyleForTextElement(e, x, y));
    }

    private String getFormatString(DataSource ds) {
        FormatFilter filter;
        if (ds instanceof NumberFieldTemplate) {
            NumberFieldTemplate nft = (NumberFieldTemplate)ds;
            return nft.getFormat();
        }
        if (ds instanceof DateFieldTemplate) {
            DateFieldTemplate dft = (DateFieldTemplate)ds;
            return dft.getFormat();
        }
        if (ds instanceof DateFormatFilter) {
            filter = (DateFormatFilter)ds;
            if (((DateFormatFilter)filter).getDateFormat() instanceof SimpleDateFormat) {
                SimpleDateFormat dateFormat = (SimpleDateFormat)((DateFormatFilter)filter).getDateFormat();
                return dateFormat.toLocalizedPattern();
            }
        } else if (ds instanceof NumberFormatFilter && ((NumberFormatFilter)(filter = (NumberFormatFilter)ds)).getNumberFormat() instanceof DecimalFormat) {
            DecimalFormat dateFormat = (DecimalFormat)((NumberFormatFilter)filter).getNumberFormat();
            return dateFormat.toLocalizedPattern();
        }
        if (ds instanceof DataTarget) {
            DataTarget dt = (DataTarget)((Object)ds);
            return this.getFormatString(dt.getDataSource());
        }
        return null;
    }

    public boolean isDefineDataFormats() {
        return this.defineDataFormats;
    }
}

