/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportEventException;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.event.RepaginationListener;
import org.jfree.report.event.RepaginationState;
import org.jfree.report.modules.output.meta.MetaBandProducer;
import org.jfree.report.modules.output.table.base.DefaultLayoutCreator;
import org.jfree.report.modules.output.table.base.LayoutCreator;
import org.jfree.report.modules.output.table.base.TableCreator;
import org.jfree.report.modules.output.table.base.TableWriter;
import org.jfree.report.states.FinishState;
import org.jfree.report.states.ReportState;
import org.jfree.report.states.ReportStateProgress;
import org.jfree.report.states.StartState;
import org.jfree.report.util.geom.StrictGeomUtility;

public abstract class TableProcessor {
    private static final int MAX_EVENTS_PER_RUN = 400;
    public static final String STRICT_LAYOUT_DEFAULT = "false";
    public static final String STRICT_LAYOUT = "StrictLayout";
    private static final String TABLE_WRITER = String.valueOf((class$org$jfree$report$modules$output$table$base$TableProcessor != null ? class$org$jfree$report$modules$output$table$base$TableProcessor : (class$org$jfree$report$modules$output$table$base$TableProcessor = TableProcessor.class$("org.jfree.report.modules.output.table.base.TableProcessor"))).getName()) + "$table-writer";
    public static final String TITLE = "Title";
    public static final String AUTHOR = "Author";
    private JFreeReport report;
    private TableWriter tableWriter;
    private boolean handleInterruptedState;
    private ArrayList listeners;
    private Object[] listenersCache;
    private transient LayoutCreator layoutCreator;
    public static final String GLOBAL_LAYOUT = "GlobalLayout";
    public static final String GLOBAL_LAYOUT_DEFAULT = "false";
    static /* synthetic */ Class class$org$jfree$report$modules$output$table$base$TableProcessor;

    public TableProcessor(JFreeReport report) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        try {
            this.report = (JFreeReport)report.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Initial Clone of Report failed");
        }
        this.tableWriter = new TableWriter(this.createMetaBandProducer());
        this.tableWriter.setName(TABLE_WRITER);
        this.report.addExpression(this.tableWriter);
    }

    public void addRepaginationListener(RepaginationListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(5);
        }
        this.listenersCache = null;
        this.listeners.add(l);
    }

    protected void checkInterrupted() throws ReportInterruptedException {
        if (this.isHandleInterruptedState() && Thread.interrupted()) {
            throw new ReportInterruptedException("Current thread is interrupted. Returning.");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void configure() {
        this.getTableWriter().setMaxWidth(StrictGeomUtility.toInternalValue(this.getReport().getPageDefinition().getWidth()));
    }

    protected abstract TableCreator createContentCreator();

    protected LayoutCreator createLayoutCreator() {
        return new DefaultLayoutCreator(this.getReportConfigurationPrefix());
    }

    protected abstract MetaBandProducer createMetaBandProducer();

    protected void fireStateUpdate(RepaginationState state) {
        if (this.listeners == null) {
            return;
        }
        if (this.listenersCache == null) {
            this.listenersCache = this.listeners.toArray();
        }
        int i = 0;
        while (i < this.listenersCache.length) {
            RepaginationListener l = (RepaginationListener)this.listenersCache[i];
            l.repaginationUpdate(state);
            ++i;
        }
    }

    protected LayoutCreator getLayoutCreator() {
        if (this.layoutCreator == null) {
            throw new IllegalStateException("No layout created detected.");
        }
        return this.layoutCreator;
    }

    protected JFreeReport getReport() {
        return this.report;
    }

    protected abstract String getReportConfigurationPrefix();

    protected TableWriter getTableWriter() {
        return this.tableWriter;
    }

    public boolean isHandleInterruptedState() {
        return this.handleInterruptedState;
    }

    public boolean isStrictLayout() {
        return this.report.getReportConfiguration().getConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + STRICT_LAYOUT, "false").equals("true");
    }

    public synchronized void processReport() throws ReportProcessingException {
        ReportState state = this.repaginate();
        TableWriter w = (TableWriter)state.getDataRow().get(TABLE_WRITER);
        w.setTableCreator(this.createContentCreator());
        w.setMaxWidth(StrictGeomUtility.toInternalValue(this.getReport().getPageDefinition().getWidth()));
        RepaginationState stateEvent = new RepaginationState(this, 0, 0, 0, 0, false);
        int maxRows = state.getNumberOfRows();
        int lastRow = -1;
        int eventCount = 0;
        int eventTrigger = maxRows / 400;
        boolean failOnError = this.getReport().getReportConfiguration().isStrictErrorHandling();
        ReportStateProgress progress = null;
        while (!state.isFinish()) {
            this.checkInterrupted();
            if (lastRow != state.getCurrentDisplayItem()) {
                lastRow = state.getCurrentDisplayItem();
                if (eventCount == 0) {
                    stateEvent.reuse(-1, state.getCurrentPage(), state.getCurrentDataItem(), state.getNumberOfRows(), true);
                    this.fireStateUpdate(stateEvent);
                    ++eventCount;
                } else {
                    eventCount = eventCount == eventTrigger ? 0 : ++eventCount;
                }
            }
            progress = state.createStateProgress(progress);
            state = state.advance();
            if (failOnError && state.isErrorOccured()) {
                throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
            }
            if (state.isFinish() || state.isProceeding(progress)) continue;
            throw new ReportProcessingException("State did not proceed, bailing out!");
        }
    }

    public void removeRepaginationListener(RepaginationListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            return;
        }
        this.listenersCache = null;
        ((AbstractCollection)this.listeners).remove(l);
    }

    private ReportState repaginate() throws ReportProcessingException {
        this.configure();
        try {
            boolean hasNext;
            StartState startState = new StartState(this.getReport());
            ReportState state = startState;
            ReportState retval = null;
            state.setProperty("report.preparerun", Boolean.TRUE);
            TableWriter w = (TableWriter)state.getDataRow().get(TABLE_WRITER);
            this.layoutCreator = this.createLayoutCreator();
            w.setTableCreator(this.layoutCreator);
            state.setProperty("report.layout-support", w.getLayoutSupport());
            Iterator it = startState.getLevels();
            if (!it.hasNext()) {
                throw new IllegalStateException("No functions defined, invalid implementation.");
            }
            int eventTrigger = state.getNumberOfRows() / 400;
            RepaginationState stateEvent = new RepaginationState(this, 0, 0, 0, 0, false);
            ReportStateProgress progress = null;
            int level = (Integer)it.next();
            do {
                if (level == -1) {
                    retval = (ReportState)state.clone();
                }
                int lastRow = -1;
                int eventCount = 0;
                boolean failOnError = level == -1 && this.getReport().getReportConfiguration().isStrictErrorHandling();
                while (!state.isFinish()) {
                    this.checkInterrupted();
                    if (lastRow != state.getCurrentDisplayItem()) {
                        lastRow = state.getCurrentDisplayItem();
                        if (eventCount == 0) {
                            stateEvent.reuse(level, state.getCurrentPage(), state.getCurrentDataItem(), state.getNumberOfRows(), true);
                            this.fireStateUpdate(stateEvent);
                            ++eventCount;
                        } else {
                            eventCount = eventCount == eventTrigger ? 0 : ++eventCount;
                        }
                    }
                    progress = state.createStateProgress(progress);
                    state = state.advance();
                    if (failOnError && state.isErrorOccured()) {
                        throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                    }
                    if (state.isFinish() || state.isProceeding(progress)) continue;
                    throw new ReportProcessingException("State did not proceed, bailing out!");
                }
                hasNext = it.hasNext();
                if (!hasNext) continue;
                level = (Integer)it.next();
                if (state instanceof FinishState) {
                    state = new StartState((FinishState)state, level);
                    continue;
                }
                throw new IllegalStateException("Repaginate did not produce an finish state");
            } while (hasNext);
            state.setProperty("report.preparerun", Boolean.FALSE);
            StartState sretval = (StartState)retval;
            if (sretval == null) {
                throw new IllegalStateException("There was no valid pagination done.");
            }
            sretval.resetState();
            return sretval;
        }
        catch (CloneNotSupportedException cne) {
            throw new ReportProcessingException("Unable to initialize the report, clone error", cne);
        }
    }

    public void setHandleInterruptedState(boolean handleInterruptedState) {
        this.handleInterruptedState = handleInterruptedState;
    }

    public void setStrictLayout(boolean strictLayout) {
        this.report.getReportConfiguration().setConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + STRICT_LAYOUT, String.valueOf(strictLayout));
    }
}

