/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaBand;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.AbstractTableCreator;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.SheetLayoutCollection;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.util.Log;

public abstract class TableContentCreator
extends AbstractTableCreator {
    public static final String SHEET_NAME_FUNCTION_PROPERTY = "org.jfree.report.targets.table.TableWriter.SheetNameFunction";
    public static final String DEBUG_REPORT_LAYOUT = "org.jfree.report.targets.table.TableWriter.DebugReportLayout";
    private GenericObjectTable backend;
    private SheetLayoutCollection sheetLayoutCollection;
    private SheetLayout currentLayout;
    private int tableCounter;
    private TableRectangle lookupRectangle;
    private String sheetNameFunction;
    private int layoutOffset;
    private boolean debugReportLayout;

    public TableContentCreator(SheetLayoutCollection sheetLayoutCollection) {
        if (sheetLayoutCollection == null) {
            throw new NullPointerException();
        }
        this.sheetLayoutCollection = sheetLayoutCollection;
        this.backend = new GenericObjectTable();
        this.lookupRectangle = new TableRectangle();
    }

    public final void beginTable(ReportDefinition report) throws ReportProcessingException {
        this.setEmpty(true);
        this.backend.clear();
        ++this.tableCounter;
        this.layoutOffset = 0;
        this.currentLayout = this.sheetLayoutCollection.getLayoutForPage(this.tableCounter);
        this.handleBeginTable(report);
    }

    public final void close() throws ReportProcessingException {
        this.handleClose();
        this.tableCounter = -1;
    }

    public final void endTable() throws ReportProcessingException {
        this.handleEndTable();
        this.backend.clear();
        this.setEmpty(true);
        this.currentLayout = null;
    }

    public final boolean flush() throws ReportProcessingException {
        if (this.debugReportLayout) {
            Log.debug((Object)("Begin Flush! " + this.layoutOffset));
        }
        if (this.handleFlush()) {
            this.layoutOffset += this.backend.getRowCount();
            this.backend.clear();
            return true;
        }
        return false;
    }

    protected GenericObjectTable getBackend() {
        return this.backend;
    }

    protected SheetLayout getCurrentLayout() {
        return this.currentLayout;
    }

    protected int getCurrentTableNumber() {
        return this.tableCounter;
    }

    public int getLayoutOffset() {
        return this.layoutOffset;
    }

    protected final TableRectangle getLookupRectangle() {
        return this.lookupRectangle;
    }

    protected String getSheetNameFunction() {
        return this.sheetNameFunction;
    }

    protected abstract void handleBeginTable(ReportDefinition var1) throws ReportProcessingException;

    protected abstract void handleClose() throws ReportProcessingException;

    protected abstract void handleEndTable() throws ReportProcessingException;

    protected boolean handleFlush() throws ReportProcessingException {
        return false;
    }

    protected abstract void handleOpen(ReportDefinition var1) throws ReportProcessingException;

    private boolean isCellSpaceOccupied(TableRectangle rect) {
        int x2 = rect.getX2();
        int y2 = rect.getY2() - this.layoutOffset;
        int r = rect.getY1() - this.layoutOffset;
        while (r < y2) {
            int c = rect.getX1();
            while (c < x2) {
                MetaElement object = (MetaElement)this.backend.getObject(r, c);
                if (object != null) {
                    if (this.debugReportLayout) {
                        Log.debug((Object)("Cell (" + c + ", " + r + ") already filled: " + "Content in cell: " + object));
                    }
                    return true;
                }
                ++c;
            }
            ++r;
        }
        return false;
    }

    protected boolean isDebugReportLayout() {
        return this.debugReportLayout;
    }

    public final void open(ReportDefinition report) throws ReportProcessingException {
        this.tableCounter = -1;
        this.sheetNameFunction = report.getReportConfiguration().getConfigProperty(SHEET_NAME_FUNCTION_PROPERTY);
        this.debugReportLayout = report.getReportConfiguration().getConfigProperty(DEBUG_REPORT_LAYOUT, "true").equals("true");
        this.handleOpen(report);
    }

    protected boolean processBandDefinition(MetaBand e) {
        return false;
    }

    protected void processElement(MetaElement e) {
        if (this.currentLayout == null) {
            throw new IllegalStateException("No current layout");
        }
        TableRectangle rect = this.currentLayout.getTableBounds(e, this.getLookupRectangle());
        if (e instanceof TableCellBackground) {
            int x2 = rect.getX2();
            int y2 = rect.getY2() - this.layoutOffset;
            this.backend.ensureCapacity(x2, y2);
            return;
        }
        if (!this.isCellSpaceOccupied(rect)) {
            int x2 = rect.getX2();
            int y2 = rect.getY2() - this.layoutOffset;
            this.backend.ensureCapacity(x2, y2);
            int r = rect.getY1() - this.layoutOffset;
            while (r < y2) {
                int c = rect.getX1();
                while (c < x2) {
                    this.backend.setObject(r, c, e);
                    ++c;
                }
                ++r;
            }
            this.setEmpty(false);
        } else if (this.debugReportLayout) {
            Log.debug((Object)("Offending Content: " + e));
        }
    }
}

