/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.io.IOException;
import java.io.OutputStream;
import org.jfree.report.modules.output.pageable.plaintext.AbstractEpsonPrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecificationManager;
import org.jfree.report.util.ReportConfiguration;

public class Epson9PinPrinterDriver
extends AbstractEpsonPrinterDriver {
    private static PrinterSpecificationManager printerSpecificationManager;
    private static final String SPECIFICATION_RESOURCE = "epson-9pin-printer-specifications.properties";
    public static final String EPSON_9PIN_PRINTER_TYPE = "org.jfree.report.modules.output.pageable.plaintext.epson.9PinPrinterType";

    public Epson9PinPrinterDriver(OutputStream out, float charsPerInch, float linesPerInch, String printerModel) {
        super(out, charsPerInch, linesPerInch, printerModel);
    }

    public static String getDefaultPrinter() {
        return ReportConfiguration.getGlobalConfig().getConfigProperty(EPSON_9PIN_PRINTER_TYPE, "Generic 9-Pin printer");
    }

    protected PrinterSpecificationManager getPrinterSpecificationManager() {
        return Epson9PinPrinterDriver.loadSpecificationManager();
    }

    public static synchronized PrinterSpecificationManager loadSpecificationManager() {
        if (printerSpecificationManager == null) {
            printerSpecificationManager = new PrinterSpecificationManager();
            printerSpecificationManager.load(SPECIFICATION_RESOURCE);
        }
        return printerSpecificationManager;
    }

    protected void sendDefineLineSpacing(float lineHeightInPoints) throws IOException {
        int spacePar = (int)(lineHeightInPoints * 3.0f);
        this.getOut().write(27);
        this.getOut().write(51);
        this.getOut().write(spacePar);
    }

    protected void sendFontStyle(boolean bold, boolean italic, boolean underline, boolean strikeTrough) throws IOException {
        OutputStream out = this.getOut();
        AbstractEpsonPrinterDriver.DriverState driverState = this.getDriverState();
        if (driverState.isBold()) {
            if (!bold) {
                out.write(27);
                out.write(70);
            }
        } else if (bold) {
            out.write(27);
            out.write(69);
        }
        if (driverState.isItalic()) {
            if (!italic) {
                out.write(27);
                out.write(53);
            }
        } else if (italic) {
            out.write(27);
            out.write(52);
        }
        if (driverState.isUnderline()) {
            if (!underline) {
                out.write(27);
                out.write(45);
                out.write(0);
            }
        } else if (underline) {
            out.write(27);
            out.write(45);
            out.write(1);
        }
        driverState.setBold(bold);
        driverState.setItalic(italic);
        driverState.setUnderline(underline);
        driverState.setStrikethrough(false);
    }
}

