/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base.operations;

import org.jfree.report.ElementAlignment;
import org.jfree.report.content.Content;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.pageable.base.operations.BottomAlignment;
import org.jfree.report.modules.output.pageable.base.operations.CenterAlignment;
import org.jfree.report.modules.output.pageable.base.operations.HorizontalBoundsAlignment;
import org.jfree.report.modules.output.pageable.base.operations.LeftAlignment;
import org.jfree.report.modules.output.pageable.base.operations.MiddleAlignment;
import org.jfree.report.modules.output.pageable.base.operations.RightAlignment;
import org.jfree.report.modules.output.pageable.base.operations.TopAlignment;
import org.jfree.report.modules.output.pageable.base.operations.VerticalBoundsAlignment;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictBounds;

public final class AlignmentTools {
    private AlignmentTools() {
    }

    public static StrictBounds computeAlignmentBounds(MetaElement e) {
        Content content = e.getContent();
        StrictBounds bounds = e.getBounds();
        ElementAlignment va = (ElementAlignment)e.getProperty(ElementStyleSheet.VALIGNMENT);
        VerticalBoundsAlignment vba = AlignmentTools.getVerticalLayout(va, bounds);
        ElementAlignment ha = (ElementAlignment)e.getProperty(ElementStyleSheet.ALIGNMENT);
        HorizontalBoundsAlignment hba = AlignmentTools.getHorizontalLayout(ha, bounds);
        StrictBounds halignedBounds = hba.align(content.getBounds());
        StrictBounds abounds = vba.align(halignedBounds);
        return abounds;
    }

    public static HorizontalBoundsAlignment getHorizontalLayout(ElementAlignment ha, StrictBounds bounds) {
        if (ha.equals(ElementAlignment.CENTER)) {
            return new CenterAlignment(bounds);
        }
        if (ha.equals(ElementAlignment.RIGHT)) {
            return new RightAlignment(bounds);
        }
        return new LeftAlignment(bounds);
    }

    public static VerticalBoundsAlignment getVerticalLayout(ElementAlignment va, StrictBounds bounds) {
        if (va.equals(ElementAlignment.TOP)) {
            return new TopAlignment(bounds);
        }
        if (va.equals(ElementAlignment.MIDDLE)) {
            return new MiddleAlignment(bounds);
        }
        return new BottomAlignment(bounds);
    }
}

