/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.report.DataRow;
import org.jfree.report.Group;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.FunctionProcessingException;
import org.jfree.report.modules.output.csv.CSVQuoter;
import org.jfree.report.util.ReportConfiguration;

public class CSVWriter
extends AbstractFunction {
    private Writer w;
    private int depLevel;
    private final CSVQuoter quoter;
    private boolean writeDataRowNames;

    public CSVWriter() {
        this.setDependencyLevel(-1);
        this.quoter = new CSVQuoter();
    }

    public int getDependencyLevel() {
        return this.depLevel;
    }

    public String getSeparator() {
        return this.quoter.getSeparator();
    }

    public Object getValue() {
        return this;
    }

    public Writer getWriter() {
        return this.w;
    }

    public void groupFinished(ReportEvent event) {
        try {
            int currentIndex = event.getState().getCurrentGroupIndex();
            CSVRow row = new CSVRow(this.quoter);
            row.append(currentIndex);
            Group g = event.getReport().getGroup(currentIndex);
            String bandInfo = "groupfooter name=\"" + g.getName() + "\"";
            row.append(bandInfo);
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public void groupStarted(ReportEvent event) {
        try {
            int currentIndex = event.getState().getCurrentGroupIndex();
            CSVRow row = new CSVRow(this.quoter);
            row.append(currentIndex);
            Group g = event.getReport().getGroup(currentIndex);
            String bandInfo = "groupheader name=\"" + g.getName() + "\"";
            row.append(bandInfo);
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public boolean isWriteDataRowNames() {
        return this.writeDataRowNames;
    }

    public void itemsAdvanced(ReportEvent event) {
        try {
            CSVRow row = new CSVRow(this.quoter);
            row.append(event.getState().getCurrentGroupIndex());
            row.append("itemband");
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public void reportFinished(ReportEvent event) {
        try {
            CSVRow row = new CSVRow(this.quoter);
            row.append(-1);
            row.append("reportfooter");
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public void reportStarted(ReportEvent event) {
        try {
            if (this.isWriteDataRowNames()) {
                CSVRow names = new CSVRow(this.quoter);
                names.append("report.currentgroup");
                names.append("report.eventtype");
                this.writeDataRowNames(event.getDataRow(), names);
                names.write(this.getWriter());
            }
            CSVRow row = new CSVRow(this.quoter);
            row.append(-1);
            row.append("reportheader");
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public void setDependencyLevel(int deplevel) {
        this.depLevel = deplevel;
    }

    public void setSeparator(String separator) {
        if (separator == null) {
            throw new NullPointerException();
        }
        if (separator.length() == 0) {
            throw new IllegalArgumentException("Separator must not be an empty string");
        }
        this.quoter.setSeparator(separator);
    }

    public void setWriteDataRowNames(boolean writeDataRowNames) {
        this.writeDataRowNames = writeDataRowNames;
    }

    public void setWriter(Writer w) {
        this.w = w;
    }

    private void writeDataRow(DataRow dr, CSVRow row) {
        int i = 0;
        while (i < dr.getColumnCount()) {
            Object o = dr.get(i);
            if (o == null) {
                row.append(o);
            } else if (o != this) {
                row.append(o);
            }
            ++i;
        }
    }

    private void writeDataRowNames(DataRow dr, CSVRow row) {
        int i = 0;
        while (i < dr.getColumnCount()) {
            row.append(dr.getColumnName(i));
            ++i;
        }
    }

    private static class CSVRow {
        private final ArrayList data = new ArrayList();
        private final CSVQuoter quoter;
        private final String lineSeparator;

        public CSVRow(CSVQuoter quoter) {
            this.quoter = quoter;
            this.lineSeparator = ReportConfiguration.getGlobalConfig().getConfigProperty("line.separator", "\n");
        }

        public void append(int value) {
            this.data.add(new Integer(value));
        }

        public void append(Object o) {
            this.data.add(o);
        }

        public void write(Writer w) throws IOException {
            Iterator it = ((AbstractList)this.data).iterator();
            while (it.hasNext()) {
                w.write(this.quoter.doQuoting(String.valueOf(it.next())));
                if (!it.hasNext()) continue;
                w.write(",");
            }
            w.write(this.lineSeparator);
        }
    }
}

