/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.csv;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportEventException;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.csv.CSVWriter;
import org.jfree.report.states.FinishState;
import org.jfree.report.states.ReportState;
import org.jfree.report.states.ReportStateProgress;
import org.jfree.report.states.StartState;
import org.jfree.report.util.NullOutputStream;

public class CSVProcessor {
    public static final String CSV_SEPARATOR = "org.jfree.report.modules.output.csv.Separator";
    public static final String CSV_DATAROWNAME = "org.jfree.report.modules.output.csv.WriteDatarowNames";
    private static final String CSV_WRITER = "org.jfree.report.modules.output.csv.csv-writer";
    private Writer writer;
    private JFreeReport report;
    private boolean handleInterruptedState;

    public CSVProcessor(JFreeReport report) throws ReportProcessingException {
        this(report, report.getReportConfiguration().getConfigProperty(CSV_SEPARATOR, ","));
    }

    public CSVProcessor(JFreeReport report, String separator) throws ReportProcessingException {
        this(report, separator, report.getReportConfiguration().getConfigProperty(CSV_DATAROWNAME, "false").equals("true"));
    }

    public CSVProcessor(JFreeReport report, String separator, boolean writeDataRowNames) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        try {
            this.report = (JFreeReport)report.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Initial Clone of Report failed");
        }
        CSVWriter lm = new CSVWriter();
        lm.setName(CSV_WRITER);
        lm.setSeparator(separator);
        lm.setWriteDataRowNames(writeDataRowNames);
        this.report.addExpression(lm);
    }

    protected void checkInterrupted() throws ReportInterruptedException {
        if (this.isHandleInterruptedState() && Thread.interrupted()) {
            throw new ReportInterruptedException("Current thread is interrupted. Returning.");
        }
    }

    protected JFreeReport getReport() {
        return this.report;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isHandleInterruptedState() {
        return this.handleInterruptedState;
    }

    public void processReport() throws ReportProcessingException {
        if (this.writer == null) {
            throw new IllegalStateException("No writer defined");
        }
        try {
            ReportState state = this.repaginate();
            CSVWriter w = (CSVWriter)state.getDataRow().get(CSV_WRITER);
            w.setWriter(this.getWriter());
            boolean failOnError = this.getReport().getReportConfiguration().isStrictErrorHandling();
            ReportStateProgress progress = null;
            while (!state.isFinish()) {
                this.checkInterrupted();
                progress = state.createStateProgress(progress);
                state = state.advance();
                if (failOnError && state.isErrorOccured()) {
                    throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                }
                if (state.isFinish() || state.isProceeding(progress)) continue;
                throw new ReportProcessingException("State did not proceed, bailing out!");
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("StateCopy was not supported");
        }
    }

    private ReportState repaginate() throws ReportProcessingException, CloneNotSupportedException {
        boolean hasNext;
        StartState startState;
        try {
            startState = new StartState(this.getReport());
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Unable to clone the start state.", e);
        }
        ReportState state = startState;
        ReportState retval = null;
        state.setProperty("report.preparerun", Boolean.TRUE);
        CSVWriter w = (CSVWriter)state.getDataRow().get(CSV_WRITER);
        w.setWriter(new OutputStreamWriter(new NullOutputStream()));
        Iterator it = startState.getLevels();
        if (!it.hasNext()) {
            throw new IllegalStateException("No functions defined, invalid implementation.");
        }
        int level = (Integer)it.next();
        ReportStateProgress progress = null;
        do {
            if (level == -1) {
                retval = (ReportState)state.clone();
            }
            boolean failOnError = level == -1 && this.getReport().getReportConfiguration().isStrictErrorHandling();
            while (!state.isFinish()) {
                this.checkInterrupted();
                progress = state.createStateProgress(progress);
                state = state.advance();
                if (failOnError && state.isErrorOccured()) {
                    throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                }
                if (state.isFinish() || state.isProceeding(progress)) continue;
                throw new ReportProcessingException("State did not proceed, bailing out!");
            }
            hasNext = it.hasNext();
            if (!hasNext) continue;
            level = (Integer)it.next();
            if (state instanceof FinishState) {
                state = new StartState((FinishState)state, level);
                continue;
            }
            throw new IllegalStateException("The processing did not produce an finish state");
        } while (hasNext);
        state.setProperty("report.preparerun", Boolean.FALSE);
        StartState sretval = (StartState)retval;
        if (sretval == null) {
            throw new IllegalStateException("There was no valid pagination done.");
        }
        sretval.resetState();
        return sretval;
    }

    public void setHandleInterruptedState(boolean handleInterruptedState) {
        this.handleInterruptedState = handleInterruptedState;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

