/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import org.jfree.report.modules.misc.tablemodel.ScrollableResultSetTableModel;
import org.jfree.report.util.CloseableTableModel;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;

public final class ResultSetTableModelFactory {
    public static final String COLUMN_NAME_MAPPING_KEY = "org.jfree.report.modules.misc.tablemodel.ColumnNameMapping";
    public static final String RESULTSET_FACTORY_MODE = "org.jfree.report.modules.misc.tablemodel.TableFactoryMode";
    private static ResultSetTableModelFactory defaultInstance;

    private ResultSetTableModelFactory() {
    }

    public CloseableTableModel createTableModel(ResultSet rs) throws SQLException {
        return this.createTableModel(rs, ReportConfiguration.getGlobalConfig().getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label").equals("Label"));
    }

    public CloseableTableModel createTableModel(ResultSet rs, boolean labelMapping) throws SQLException {
        String prop = ReportConfiguration.getGlobalConfig().getConfigProperty(RESULTSET_FACTORY_MODE, "");
        if (prop.equalsIgnoreCase("simple")) {
            return this.generateDefaultTableModel(rs, labelMapping);
        }
        int resultSetType = 1003;
        try {
            resultSetType = rs.getType();
        }
        catch (SQLException sQLException) {
            Log.info("ResultSet type could not be determined, assuming default table model.");
        }
        if (resultSetType == 1003) {
            return this.generateDefaultTableModel(rs, labelMapping);
        }
        return new ScrollableResultSetTableModel(rs, labelMapping);
    }

    public CloseableTableModel generateDefaultTableModel(ResultSet rs) throws SQLException {
        return this.generateDefaultTableModel(rs, ReportConfiguration.getGlobalConfig().getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label").equals("Label"));
    }

    public CloseableTableModel generateDefaultTableModel(ResultSet rs, boolean labelMapping) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int colcount = rsmd.getColumnCount();
        ArrayList<String> header = new ArrayList<String>(colcount);
        int i = 0;
        while (i < colcount) {
            String name;
            if (labelMapping) {
                name = rsmd.getColumnLabel(i + 1);
                header.add(name);
            } else {
                name = rsmd.getColumnName(i + 1);
                header.add(name);
            }
            ++i;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] column = new Object[colcount];
            int i2 = 0;
            while (i2 < colcount) {
                Object val;
                column[i2] = val = rs.getObject(i2 + 1);
                ++i2;
            }
            rows.add(column);
        }
        Object[] tempRows = rows.toArray();
        Object[][] rowMap = new Object[tempRows.length][];
        int i3 = 0;
        while (i3 < tempRows.length) {
            rowMap[i3] = (Object[])tempRows[i3];
            ++i3;
        }
        class Org_jfree_report_modules_misc_tablemodel_ResultSetTableModelFactory$1 {
            /* synthetic */ Org_jfree_report_modules_misc_tablemodel_ResultSetTableModelFactory$1() {
            }
        }
        CloseableDefaultTableModel model = new CloseableDefaultTableModel(null, rowMap, header.toArray(), rs);
        int i4 = 0;
        while (i4 < colcount) {
            ++i4;
        }
        return model;
    }

    public static synchronized ResultSetTableModelFactory getInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ResultSetTableModelFactory();
        }
        return defaultInstance;
    }

    private static final class CloseableDefaultTableModel
    extends DefaultTableModel
    implements CloseableTableModel {
        private final ResultSet res;

        /* synthetic */ CloseableDefaultTableModel(1 $0, Object[][] $1, Object[] $2, ResultSet $3) {
            this($1, $2, $3);
        }

        private CloseableDefaultTableModel(Object[][] objects, Object[] objects1, ResultSet res) {
            super(objects, objects1);
            this.res = res;
        }

        public void close() {
            this.setDataVector(new Object[0][0], new Object[0]);
            try {
                this.res.close();
            }
            catch (Exception exception) {}
        }
    }
}

