/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.xls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.components.AbstractExportDialog;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.FilesystemFilter;
import org.jfree.ui.action.ActionButton;

public class ExcelExportDialog
extends AbstractExportDialog {
    private Action actionSelectFile;
    private JTextField txFilename;
    private JCheckBox cbStrictLayout;
    private JFileChooser fileChooser;

    public ExcelExportDialog() {
        this.initConstructor();
    }

    public ExcelExportDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public ExcelExportDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public void clear() {
        this.txFilename.setText("");
        this.cbStrictLayout.setSelected(false);
    }

    private Action getActionSelectFile() {
        return this.actionSelectFile;
    }

    protected String getConfigurationSuffix() {
        return "_xlsexport";
    }

    public Properties getDialogContents() {
        Properties p = new Properties();
        p.setProperty("filename", this.getFilename());
        p.setProperty("strict-layout", String.valueOf(this.isStrictLayout()));
        return p;
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    protected String getResourceBaseName() {
        return "org.jfree.report.modules.gui.xls.resources.xls-export-resources";
    }

    private void initConstructor() {
        this.actionSelectFile = new ActionSelectFile(this.getResources());
        this.setCancelAction(new CancelAction(this.getResources()));
        this.setConfirmAction(new ConfirmAction(this.getResources()));
        this.setTitle(this.getResources().getString("excelexportdialog.dialogtitle"));
        this.initialize();
        this.clear();
    }

    public void initFromConfiguration(ReportConfiguration config) {
        String strict = config.getConfigProperty("org.jfree.report.modules.output.table.xlsStrictLayout", config.getConfigProperty("StrictLayout", "false"));
        this.setStrictLayout(strict.equals("true"));
    }

    private void initialize() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblFileName = new JLabel(this.getResources().getString("excelexportdialog.filename"));
        ActionButton btnSelect = new ActionButton(this.getActionSelectFile());
        this.txFilename = new JTextField();
        this.cbStrictLayout = new JCheckBox(this.getResources().getString("excelexportdialog.strict-layout"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 5);
        contentPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 120;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 120;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbStrictLayout, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        contentPane.add((Component)btnSelect, gbc);
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonPanel.add((Component)btnConfirm);
        buttonPanel.add((Component)btnCancel);
        btnConfirm.setDefaultCapable(true);
        this.getRootPane().setDefaultButton((JButton)btnConfirm);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke('\n'), 1);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = 6;
        gbc.insets = new Insets(10, 0, 10, 0);
        contentPane.add((Component)buttonPanel, gbc);
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)contentPane, "Center");
        contentWithStatus.add((Component)this.getStatusBar(), "South");
        this.setContentPane(contentWithStatus);
        this.getFormValidator().registerButton(this.cbStrictLayout);
        this.getFormValidator().registerTextField(this.txFilename);
    }

    public boolean isStrictLayout() {
        return this.cbStrictLayout.isSelected();
    }

    public static void main(String[] args) {
        ExcelExportDialog dialog = new ExcelExportDialog();
        dialog.setModal(true);
        dialog.pack();
        dialog.performQueryForExport(new JFreeReport());
        System.exit(0);
    }

    protected boolean performConfirm() {
        String filename = this.getFilename();
        File f = new File(filename);
        if (f.exists()) {
            String key1 = "excelexportdialog.targetOverwriteConfirmation";
            String key2 = "excelexportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("excelexportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("excelexportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(".xls", "Excel Documents");
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        File file = new File(this.getFilename());
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.setSelectedFile(file);
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtil.endsWithIgnoreCase(selFileName, ".xls")) {
                selFileName = String.valueOf(selFileName) + ".xls";
            }
            this.setFilename(selFileName);
        }
    }

    public boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(3, this.getResources().getString("excelexportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("excelexportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("excelexportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("excelexportdialog.targetExistsWarning"), filename);
            this.getStatusBar().setStatus(2, message);
        }
        return true;
    }

    public void setDialogContents(Properties p) {
        this.setFilename(p.getProperty("filename", this.getFilename()));
        this.setStrictLayout(StringUtil.parseBoolean(p.getProperty("strict-layout"), this.isStrictLayout()));
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    public void setStrictLayout(boolean strictLayout) {
        this.cbStrictLayout.setSelected(strictLayout);
    }

    public void storeToConfiguration(ReportConfiguration config) {
        config.setConfigProperty("org.jfree.report.modules.output.table.xlsStrictLayout", String.valueOf(this.isStrictLayout()));
    }

    private class ConfirmAction
    extends AbstractExportDialog.AbstractConfirmAction {
        public ConfirmAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("excelexportdialog.confirm"));
        }
    }

    private class CancelAction
    extends AbstractExportDialog.AbstractCancelAction {
        public CancelAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("excelexportdialog.cancel"));
        }
    }

    private class ActionSelectFile
    extends AbstractAction {
        public ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("excelexportdialog.selectFile"));
        }

        public void actionPerformed(ActionEvent e) {
            ExcelExportDialog.this.performSelectFile();
        }
    }
}

