/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.plaintext;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.output.pageable.base.PageableReportProcessor;
import org.jfree.report.modules.output.pageable.plaintext.AbstractEpsonPrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.Epson24PinPrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.Epson9PinPrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.IBMCompatiblePrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.PlainTextOutputTarget;
import org.jfree.report.modules.output.pageable.plaintext.PlainTextReportUtil;
import org.jfree.report.modules.output.pageable.plaintext.PrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.TextFilePrinterDriver;
import org.jfree.report.util.Log;
import org.jfree.report.util.StringUtil;
import org.jfree.util.Log;

public class PlainTextExportTask
extends ExportTask {
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final JFreeReport report;
    private final int exportType;
    private final float charPerInch;
    private final float linesPerInch;
    private String printer;

    public PlainTextExportTask(String fileName, ReportProgressDialog dialog, int exportType, JFreeReport report, String printer) {
        if (fileName == null) {
            throw new NullPointerException("File name is null.");
        }
        if (report == null) {
            throw new NullPointerException("Report is null.");
        }
        this.fileName = fileName;
        this.progressDialog = dialog;
        this.report = report;
        this.exportType = exportType;
        this.printer = printer;
        this.charPerInch = StringUtil.parseFloat(report.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.CharsPerInch"), 10.0f);
        this.linesPerInch = StringUtil.parseFloat(report.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.LinesPerInch"), 6.0f);
    }

    private void applyFallbackEncoding(AbstractEpsonPrinterDriver driver) {
        String encoding = this.report.getReportConfiguration().getConfigProperty("org.jfree.report.modules.gui.plaintext.FallbackEncoding");
        driver.setFallBackCharset((byte)StringUtil.parseInt(encoding, 0));
    }

    protected void dispose() {
        super.dispose();
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
        }
    }

    protected PrinterDriver getPrinterCommandSet(OutputStream out) {
        switch (this.exportType) {
            case 0: {
                return new TextFilePrinterDriver(out, this.charPerInch, this.linesPerInch);
            }
            case 2: {
                return new IBMCompatiblePrinterDriver(out, this.charPerInch, this.linesPerInch);
            }
            case 1: {
                Epson9PinPrinterDriver driver = new Epson9PinPrinterDriver(out, this.charPerInch, this.linesPerInch, this.printer);
                this.applyFallbackEncoding(driver);
                return driver;
            }
            case 3: {
                Epson24PinPrinterDriver driver = new Epson24PinPrinterDriver(out, this.charPerInch, this.linesPerInch, this.printer);
                this.applyFallbackEncoding(driver);
                return driver;
            }
        }
        throw new IllegalArgumentException();
    }

    protected void performExport() {
        OutputStream out = null;
        File file = new File(this.fileName).getAbsoluteFile();
        try {
            try {
                File directory = file.getParentFile();
                if (directory != null && !directory.exists() && !directory.mkdirs()) {
                    Log.warn("Can't create directories. Hoping and praying now..");
                }
                out = new BufferedOutputStream(new FileOutputStream(file));
                PrinterDriver pc = this.getPrinterCommandSet(out);
                PlainTextOutputTarget target = new PlainTextOutputTarget(pc);
                target.configure(this.report.getReportConfiguration());
                PageableReportProcessor proc = new PageableReportProcessor(this.report);
                proc.setHandleInterruptedState(false);
                if (this.progressDialog != null) {
                    this.progressDialog.setModal(false);
                    ((Component)this.progressDialog).setVisible(true);
                    proc.addRepaginationListener(this.progressDialog);
                }
                proc.setOutputTarget(target);
                target.open();
                byte[] sequence = PlainTextReportUtil.getInitSequence(this.report);
                if (sequence != null) {
                    pc.printRaw(sequence);
                }
                proc.processReport();
                target.close();
                if (this.progressDialog != null) {
                    proc.removeRepaginationListener(this.progressDialog);
                }
                this.setTaskDone();
            }
            catch (ReportInterruptedException reportInterruptedException) {
                this.setTaskAborted();
                try {
                    out.close();
                    out = null;
                    if (!file.delete()) {
                        Log.warn(new Log.SimpleMessage("Unable to delete incomplete export:", (Object)file));
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {}
            }
            catch (Exception re) {
                Log.error("PlainText export failed", re);
                this.setTaskFailed(re);
            }
            Object var4_10 = null;
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Log.error("Unable to close the output stream.", e);
                this.setTaskFailed(e);
            }
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            Log.error("Unable to close the output stream.", e);
            this.setTaskFailed(e);
        }
        if (this.progressDialog != null) {
            ((Component)this.progressDialog).setVisible(false);
        }
    }
}

