/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.html;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.output.table.html.HtmlProcessor;
import org.jfree.report.modules.output.table.html.StreamHtmlFilesystem;
import org.jfree.report.util.Log;
import org.jfree.util.Log;

public class HtmlStreamExportTask
extends ExportTask {
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final JFreeReport report;

    public HtmlStreamExportTask(String fileName, ReportProgressDialog dialog, JFreeReport report) {
        if (fileName == null) {
            throw new NullPointerException("File name is null.");
        }
        if (report == null) {
            throw new NullPointerException("Report is null.");
        }
        this.fileName = fileName;
        this.progressDialog = dialog;
        this.report = report;
    }

    protected void dispose() {
        super.dispose();
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
        }
    }

    protected void performExport() {
        OutputStream out = null;
        File file = new File(this.fileName).getAbsoluteFile();
        try {
            try {
                File parentFile;
                File directory = file.getParentFile();
                if (directory != null && !directory.exists() && !directory.mkdirs()) {
                    Log.warn("Can't create directories. Hoping and praying now..");
                }
                out = new BufferedOutputStream(new FileOutputStream(file));
                HtmlProcessor target = new HtmlProcessor(this.report);
                if (this.progressDialog != null) {
                    this.progressDialog.setModal(false);
                    ((Component)this.progressDialog).setVisible(true);
                    target.addRepaginationListener(this.progressDialog);
                }
                if ((parentFile = file.getParentFile()) != null) {
                    target.setFilesystem(new StreamHtmlFilesystem(out, true, parentFile.toURL()));
                } else {
                    target.setFilesystem(new StreamHtmlFilesystem(out, true, file.toURL()));
                }
                target.processReport();
                out.close();
                out = null;
                if (this.progressDialog != null) {
                    target.removeRepaginationListener(this.progressDialog);
                }
                this.setTaskDone();
            }
            catch (ReportInterruptedException reportInterruptedException) {
                this.setTaskAborted();
                try {
                    out.close();
                    out = null;
                    if (!file.delete()) {
                        Log.warn(new Log.SimpleMessage("Unable to delete incomplete export:", (Object)file));
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {}
            }
            catch (Exception re) {
                Log.error("Exporting failed .", re);
                this.setTaskFailed(re);
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Log.error("Unable to close the output stream.", e);
                this.setTaskFailed(e);
            }
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            Log.error("Unable to close the output stream.", e);
            this.setTaskFailed(e);
        }
        if (this.progressDialog != null) {
            ((Component)this.progressDialog).setVisible(false);
        }
    }
}

