/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.html;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.output.table.html.DirectoryHtmlFilesystem;
import org.jfree.report.modules.output.table.html.HtmlProcessor;
import org.jfree.report.util.Log;
import org.jfree.util.Log;

public class HtmlDirExportTask
extends ExportTask {
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final String dataDirectory;
    private final JFreeReport report;

    public HtmlDirExportTask(String fileName, String dataDirectory, ReportProgressDialog dialog, JFreeReport report) {
        if (fileName == null) {
            throw new NullPointerException("File name is null.");
        }
        if (report == null) {
            throw new NullPointerException("Report is null.");
        }
        if (dataDirectory == null) {
            throw new NullPointerException("DataDirectory is null.");
        }
        this.fileName = fileName;
        this.progressDialog = dialog;
        this.dataDirectory = dataDirectory;
        this.report = report;
    }

    protected void dispose() {
        super.dispose();
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
        }
    }

    protected void performExport() {
        try {
            File targetFile = new File(this.fileName).getAbsoluteFile();
            File targetDataFile = new File(targetFile.getParentFile(), this.dataDirectory).getAbsoluteFile();
            if (!(targetDataFile.mkdirs() || targetDataFile.exists() && targetDataFile.isDirectory())) {
                throw new IOException("Unable to create the missing directories for the data file: " + targetDataFile);
            }
            File directory = targetFile.getParentFile();
            if (!(directory == null || directory.mkdirs() || directory.exists() && directory.isDirectory())) {
                throw new IOException("Unable to create the missing directories for " + directory);
            }
            DirectoryHtmlFilesystem fs = new DirectoryHtmlFilesystem(targetFile, targetDataFile);
            HtmlProcessor target = new HtmlProcessor(this.report);
            if (this.progressDialog != null) {
                this.progressDialog.setModal(false);
                ((Component)this.progressDialog).setVisible(true);
                target.addRepaginationListener(this.progressDialog);
            }
            target.setFilesystem(fs);
            target.processReport();
            if (this.progressDialog != null) {
                target.removeRepaginationListener(this.progressDialog);
            }
            this.setTaskDone();
        }
        catch (ReportInterruptedException reportInterruptedException) {
            this.setTaskAborted();
            Log.warn(new Log.SimpleMessage("Unable to delete incomplete export: File ", (Object)this.fileName, (Object)" DataDir: ", (Object)this.dataDirectory));
        }
        catch (Exception re) {
            Log.error("Exporting failed .", re);
            this.setTaskFailed(re);
        }
        if (this.progressDialog != null) {
            ((Component)this.progressDialog).setVisible(false);
        }
    }
}

