/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.components.AbstractExportDialog;
import org.jfree.report.modules.gui.base.components.EncodingComboBoxModel;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.ui.LengthLimitingDocument;
import org.jfree.ui.action.ActionButton;

public class CSVExportDialog
extends AbstractExportDialog {
    public static final String CSV_OUTPUT_ENCODING = "org.jfree.report.modules.gui.csv.Encoding";
    public static final String CSV_OUTPUT_ENCODING_DEFAULT = ReportConfiguration.getPlatformDefaultEncoding();
    private JTextField txFilename;
    private JComboBox cbEncoding;
    private EncodingComboBoxModel encodingModel;
    private JCheckBox cbxStrictLayout;
    private JCheckBox cbxColumnNamesAsFirstRow;
    private JRadioButton rbSeparatorTab;
    private JRadioButton rbSeparatorColon;
    private JRadioButton rbSeparatorSemicolon;
    private JRadioButton rbSeparatorOther;
    private JTextField txSeparatorOther;
    private JRadioButton rbExportData;
    private JRadioButton rbExportPrintedElements;
    private JFileChooser fileChooser;
    private static final String COMMA_SEPARATOR = ",";
    private static final String SEMICOLON_SEPARATOR = ";";
    private static final String TAB_SEPARATOR = "\t";
    private static final String CSV_FILE_EXTENSION = ".csv";

    public CSVExportDialog() {
        this.initConstructor();
    }

    public CSVExportDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public CSVExportDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public void clear() {
        this.txFilename.setText("");
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(ReportConfiguration.getPlatformDefaultEncoding()));
        this.rbExportPrintedElements.setSelected(true);
        this.rbSeparatorColon.setSelected(true);
        this.cbxStrictLayout.setSelected(false);
        this.cbxColumnNamesAsFirstRow.setSelected(false);
        this.cbxColumnNamesAsFirstRow.setEnabled(false);
        this.performSeparatorSelection();
    }

    private JPanel createExportTypePanel() {
        JPanel exportTypePanel = new JPanel();
        exportTypePanel.setLayout(new GridBagLayout());
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.exporttype"));
        exportTypePanel.setBorder(tb);
        this.rbExportData = new JRadioButton(this.getResources().getString("csvexportdialog.export.data"));
        this.rbExportPrintedElements = new JRadioButton(this.getResources().getString("csvexportdialog.export.printed_elements"));
        this.cbxColumnNamesAsFirstRow = new JCheckBox(this.getResources().getString("cvsexportdialog.export.columnnames"));
        this.rbExportData.addChangeListener(new RawExportSelectionChangeListener());
        this.getFormValidator().registerButton(this.rbExportData);
        this.getFormValidator().registerButton(this.rbExportPrintedElements);
        this.getFormValidator().registerButton(this.cbxColumnNamesAsFirstRow);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.rbExportData);
        btg.add(this.rbExportPrintedElements);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridwidth = 2;
        exportTypePanel.add((Component)this.rbExportPrintedElements, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridwidth = 2;
        exportTypePanel.add((Component)this.rbExportData, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 20, 1, 1);
        exportTypePanel.add((Component)this.cbxColumnNamesAsFirstRow, gbc);
        return exportTypePanel;
    }

    private JPanel createSeparatorPanel() {
        JPanel separatorPanel = new JPanel();
        separatorPanel.setLayout(new GridBagLayout());
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.separatorchar"));
        separatorPanel.setBorder(tb);
        this.rbSeparatorTab = new JRadioButton(this.getResources().getString("csvexportdialog.separator.tab"));
        this.rbSeparatorColon = new JRadioButton(this.getResources().getString("csvexportdialog.separator.colon"));
        this.rbSeparatorSemicolon = new JRadioButton(this.getResources().getString("csvexportdialog.separator.semicolon"));
        this.rbSeparatorOther = new JRadioButton(this.getResources().getString("csvexportdialog.separator.other"));
        this.getFormValidator().registerButton(this.rbSeparatorColon);
        this.getFormValidator().registerButton(this.rbSeparatorOther);
        this.getFormValidator().registerButton(this.rbSeparatorSemicolon);
        this.getFormValidator().registerButton(this.rbSeparatorTab);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.rbSeparatorTab);
        btg.add(this.rbSeparatorColon);
        btg.add(this.rbSeparatorSemicolon);
        btg.add(this.rbSeparatorOther);
        ActionSelectSeparator selectAction = new ActionSelectSeparator();
        this.rbSeparatorTab.addActionListener(selectAction);
        this.rbSeparatorColon.addActionListener(selectAction);
        this.rbSeparatorSemicolon.addActionListener(selectAction);
        this.rbSeparatorOther.addActionListener(selectAction);
        LengthLimitingDocument ldoc = new LengthLimitingDocument(1);
        this.txSeparatorOther = new JTextField();
        ((JTextComponent)this.txSeparatorOther).setDocument((Document)ldoc);
        this.getFormValidator().registerTextField(this.txSeparatorOther);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorTab, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorColon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorSemicolon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorOther, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.ipadx = 120;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.txSeparatorOther, gbc);
        return separatorPanel;
    }

    public String getCSVTargetEncoding(ReportConfiguration config) {
        return config.getConfigProperty(CSV_OUTPUT_ENCODING, CSV_OUTPUT_ENCODING_DEFAULT);
    }

    protected String getConfigurationSuffix() {
        return "_csvexport";
    }

    public Properties getDialogContents() {
        Properties p = new Properties();
        p.setProperty("filename", this.getFilename());
        p.setProperty("encoding", this.getEncoding());
        p.setProperty("separator-string", this.getSeparatorString());
        p.setProperty("strict-layout", String.valueOf(this.isStrictLayout()));
        p.setProperty("export-raw-data", String.valueOf(this.isExportRawData()));
        return p;
    }

    public String getEncoding() {
        if (this.cbEncoding.getSelectedIndex() == -1) {
            return ReportConfiguration.getPlatformDefaultEncoding();
        }
        return this.encodingModel.getEncoding(this.cbEncoding.getSelectedIndex());
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    protected String getResourceBaseName() {
        return "org.jfree.report.modules.gui.csv.resources.csv-export-resources";
    }

    public String getSeparatorString() {
        if (this.rbSeparatorColon.isSelected()) {
            return COMMA_SEPARATOR;
        }
        if (this.rbSeparatorSemicolon.isSelected()) {
            return SEMICOLON_SEPARATOR;
        }
        if (this.rbSeparatorTab.isSelected()) {
            return TAB_SEPARATOR;
        }
        if (this.rbSeparatorOther.isSelected()) {
            return this.txSeparatorOther.getText();
        }
        return "";
    }

    private void initConstructor() {
        this.setCancelAction(new CancelAction(this.getResources()));
        this.setConfirmAction(new ConfirmAction(this.getResources()));
        this.setTitle(this.getResources().getString("csvexportdialog.dialogtitle"));
        this.initialize();
        this.clear();
        this.getFormValidator().setEnabled(true);
    }

    public void initFromConfiguration(ReportConfiguration config) {
        this.setSeparatorString(config.getConfigProperty("org.jfree.report.modules.output.csv.Separator", COMMA_SEPARATOR));
        String strict = config.getConfigProperty("org.jfree.report.modules.output.table.csvStrictLayout", config.getConfigProperty("StrictLayout", "false"));
        this.setStrictLayout(strict.equals("true"));
        String colNames = config.getConfigProperty("org.jfree.report.modules.output.csv.WriteDatarowNames", "false");
        this.setColumnNamesAsFirstRow(colNames.equals("true"));
        String encoding = this.getCSVTargetEncoding(config);
        this.encodingModel.ensureEncodingAvailable(encoding);
        this.setEncoding(encoding);
    }

    private void initialize() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblFileName = new JLabel(this.getResources().getString("csvexportdialog.filename"));
        JLabel lblEncoding = new JLabel(this.getResources().getString("csvexportdialog.encoding"));
        ActionButton btnSelect = new ActionButton((Action)new ActionSelectFile(this.getResources()));
        this.cbxStrictLayout = new JCheckBox(this.getResources().getString("csvexportdialog.strict-layout"));
        this.txFilename = new JTextField();
        this.encodingModel = EncodingComboBoxModel.createDefaultModel();
        this.encodingModel.sort();
        this.cbEncoding = new JComboBox(this.encodingModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 5);
        contentPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 120;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 1, 5, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.insets = new Insets(1, 5, 5, 1);
        contentPane.add((Component)btnSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 1, 1, 1);
        contentPane.add((Component)this.cbEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbxStrictLayout, gbc);
        JPanel p = new JPanel(new GridLayout(2, 1, 5, 5));
        p.add(this.createSeparatorPanel());
        p.add(this.createExportTypePanel());
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 1, 1, 1);
        contentPane.add((Component)p, gbc);
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonPanel.add((Component)btnConfirm);
        buttonPanel.add((Component)btnCancel);
        btnConfirm.setDefaultCapable(true);
        this.getRootPane().setDefaultButton((JButton)btnConfirm);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.gridy = 6;
        gbc.insets = new Insets(10, 0, 10, 0);
        gbc.anchor = 13;
        contentPane.add((Component)buttonPanel, gbc);
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)contentPane, "Center");
        contentWithStatus.add((Component)this.getStatusBar(), "South");
        this.setContentPane(contentWithStatus);
        this.getFormValidator().registerButton(this.cbxStrictLayout);
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerComboBox(this.cbEncoding);
    }

    public boolean isColumnNamesAsFirstRow() {
        return this.cbxColumnNamesAsFirstRow.isSelected();
    }

    public boolean isExportRawData() {
        return this.rbExportData.isSelected();
    }

    public boolean isStrictLayout() {
        return this.cbxStrictLayout.isSelected();
    }

    public static void main(String[] args) {
        CSVExportDialog dialog = new CSVExportDialog();
        dialog.setModal(true);
        dialog.pack();
        dialog.performQueryForExport(new JFreeReport());
        System.exit(0);
    }

    protected boolean performConfirm() {
        File f = new File(this.getFilename());
        if (f.exists()) {
            String key1 = "csvexportdialog.targetOverwriteConfirmation";
            String key2 = "csvexportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("csvexportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("csvexportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(this.getResources().getString("csvexportdialog.csv-file-description"), CSV_FILE_EXTENSION));
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        this.fileChooser.setSelectedFile(new File(this.getFilename()));
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtil.endsWithIgnoreCase(selFileName, CSV_FILE_EXTENSION)) {
                selFileName = String.valueOf(selFileName) + CSV_FILE_EXTENSION;
            }
            this.setFilename(selFileName);
        }
    }

    protected void performSeparatorSelection() {
        if (this.rbSeparatorOther.isSelected()) {
            this.txSeparatorOther.setEnabled(true);
        } else {
            this.txSeparatorOther.setEnabled(false);
        }
    }

    protected boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(3, this.getResources().getString("csvexportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("csvexportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("csvexportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("csvexportdialog.targetExistsWarning"), filename);
            this.getStatusBar().setStatus(2, message);
        }
        return true;
    }

    public void setCSVTargetEncoding(ReportConfiguration config, String targetEncoding) {
        config.setConfigProperty(CSV_OUTPUT_ENCODING, targetEncoding);
    }

    public void setColumnNamesAsFirstRow(boolean colsAsFirstRow) {
        this.cbxColumnNamesAsFirstRow.setSelected(colsAsFirstRow);
    }

    public void setDialogContents(Properties p) {
        this.setFilename(p.getProperty("filename", this.getFilename()));
        this.setEncoding(p.getProperty("encoding", this.getEncoding()));
        this.setSeparatorString(p.getProperty("separator-string", this.getSeparatorString()));
        this.setStrictLayout(StringUtil.parseBoolean(p.getProperty("strict-layout"), this.isStrictLayout()));
        this.setExportRawData(StringUtil.parseBoolean(p.getProperty("export-raw-data"), this.isExportRawData()));
    }

    public void setEncoding(String encoding) {
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(encoding));
    }

    public void setExportRawData(boolean b) {
        if (b) {
            this.rbExportData.setSelected(true);
        } else {
            this.rbExportPrintedElements.setSelected(true);
        }
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    public void setSeparatorString(String s) {
        if (s == null) {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText("");
        } else if (s.equals(COMMA_SEPARATOR)) {
            this.rbSeparatorColon.setSelected(true);
        } else if (s.equals(SEMICOLON_SEPARATOR)) {
            this.rbSeparatorSemicolon.setSelected(true);
        } else if (s.equals(TAB_SEPARATOR)) {
            this.rbSeparatorTab.setSelected(true);
        } else {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText(s);
        }
        this.performSeparatorSelection();
    }

    public void setStrictLayout(boolean strictLayout) {
        this.cbxStrictLayout.setSelected(strictLayout);
    }

    public void storeToConfiguration(ReportConfiguration config) {
        config.setConfigProperty("org.jfree.report.modules.output.csv.Separator", this.getSeparatorString());
        config.setConfigProperty("org.jfree.report.modules.output.table.csvSeparator", this.getSeparatorString());
        config.setConfigProperty("StrictLayout", String.valueOf(this.isStrictLayout()));
    }

    protected void updateRawExportSelection() {
        this.cbxColumnNamesAsFirstRow.setEnabled(this.rbExportData.isSelected());
    }

    private class ActionSelectSeparator
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            CSVExportDialog.this.performSeparatorSelection();
        }
    }

    private class ActionSelectFile
    extends AbstractAction {
        public ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("csvexportdialog.selectFile"));
        }

        public void actionPerformed(ActionEvent e) {
            CSVExportDialog.this.performSelectFile();
        }
    }

    private class RawExportSelectionChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            CSVExportDialog.this.updateRawExportSelection();
        }
    }

    private class CancelAction
    extends AbstractExportDialog.AbstractCancelAction {
        public CancelAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("csvexportdialog.cancel"));
        }
    }

    private class ConfirmAction
    extends AbstractExportDialog.AbstractConfirmAction {
        public ConfirmAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("csvexportdialog.confirm"));
        }
    }
}

