/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.converter.parser;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jfree.report.modules.gui.converter.parser.TranslationTable;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.Log;
import org.jfree.util.ObjectUtilities;

public final class TranslationTableFactory {
    private static TranslationTableFactory singleton;
    private final Hashtable contexts = new Hashtable();
    private final Properties translations = new Properties();
    static /* synthetic */ Class class$org$jfree$report$modules$gui$converter$parser$TranslationTableFactory;

    private TranslationTableFactory() {
        this.loadContextMap();
        this.loadTranslationSpecs();
    }

    private void buildContext(String base, Properties contextMap) {
        String mapTo;
        String equals = contextMap.getProperty(String.valueOf(base) + ".equal");
        if (equals != null) {
            CSVTokenizer tokenizer = new CSVTokenizer(equals, ",");
            while (tokenizer.hasMoreTokens()) {
                String context = tokenizer.nextToken().trim();
                String fqContext = String.valueOf(base) + "." + context;
                ContextRule rule = new ContextRule(fqContext, base);
                this.contexts.put(fqContext, rule);
            }
        }
        if ((mapTo = contextMap.getProperty(String.valueOf(base) + ".mapto")) != null) {
            ContextRule rule = new ContextRule(base, mapTo);
            this.contexts.put(base, rule);
            return;
        }
        String childs = contextMap.getProperty(String.valueOf(base) + ".child");
        if (childs == null) {
            throw new IllegalStateException("Property " + base + " defines no childs.");
        }
        CSVTokenizer tokenizer = new CSVTokenizer(childs, ",");
        while (tokenizer.hasMoreTokens()) {
            String context = tokenizer.nextToken().trim();
            String fqContext = String.valueOf(base) + "." + context;
            this.buildContext(fqContext, contextMap);
        }
        ContextRule rule = new ContextRule(base, null);
        this.contexts.put(base, rule);
    }

    /*
     * Unable to fully structure code
     */
    public ContextRule buildContext(ContextRule lastContext, String context) {
        if (lastContext == null) {
            return (ContextRule)this.contexts.get(context);
        }
        if (lastContext.isMappingDefined()) {
            throw new IllegalArgumentException("Unresolved mapping found.");
        }
        nextContext = (ContextRule)this.contexts.get(String.valueOf(lastContext.getName()) + "." + context);
        if (nextContext != null) ** GOTO lbl10
        Log.debug("Undefined mapping: " + lastContext.getName() + " -> " + context);
        return null;
lbl-1000:
        // 1 sources

        {
            nextContext = (ContextRule)this.contexts.get(nextContext.getMapTo());
lbl10:
            // 2 sources

            ** while (nextContext.isMappingDefined())
        }
lbl11:
        // 1 sources

        return nextContext;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static synchronized TranslationTableFactory getInstance() {
        if (singleton == null) {
            singleton = new TranslationTableFactory();
        }
        return singleton;
    }

    public TranslationTable getTranslationTable(ContextRule rule) {
        return new TranslationTable(this.translations, rule.getName());
    }

    private void loadContextMap() {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)"contextmap.properties", (Class)(class$org$jfree$report$modules$gui$converter$parser$TranslationTableFactory != null ? class$org$jfree$report$modules$gui$converter$parser$TranslationTableFactory : (class$org$jfree$report$modules$gui$converter$parser$TranslationTableFactory = TranslationTableFactory.class$("org.jfree.report.modules.gui.converter.parser.TranslationTableFactory"))));
        if (in == null) {
            Log.warn("Unable to locate the resource 'contextmap.properties'");
            return;
        }
        try {
            Properties contextProperties = new Properties();
            contextProperties.load(in);
            String initialContext = contextProperties.getProperty("%init");
            if (initialContext == null) {
                Log.debug("Initial context is null.");
                return;
            }
            CSVTokenizer tokenizer = new CSVTokenizer(initialContext, ",");
            while (tokenizer.hasMoreTokens()) {
                String context = tokenizer.nextToken().trim();
                this.buildContext(context, contextProperties);
            }
            Enumeration keys = this.contexts.keys();
            while (keys.hasMoreElements()) {
                String mapTo;
                Object key = keys.nextElement();
                ContextRule rule = (ContextRule)this.contexts.get(key);
                if (!rule.isMappingDefined() || this.contexts.get(mapTo = rule.getMapTo()) != null) continue;
                throw new IllegalStateException("No child mapping for " + key);
            }
        }
        catch (Exception e) {
            Log.error("Failed to load the context map:", e);
            return;
        }
    }

    private void loadTranslationSpecs() {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)"translations.properties", (Class)(class$org$jfree$report$modules$gui$converter$parser$TranslationTableFactory != null ? class$org$jfree$report$modules$gui$converter$parser$TranslationTableFactory : (class$org$jfree$report$modules$gui$converter$parser$TranslationTableFactory = TranslationTableFactory.class$("org.jfree.report.modules.gui.converter.parser.TranslationTableFactory"))));
        if (in == null) {
            Log.warn("Unable to locate the resource 'translations.properties'");
            return;
        }
        try {
            this.translations.load(in);
        }
        catch (Exception e) {
            Log.warn("Unable to load the translation set.", e);
        }
    }

    public static class ContextRule {
        private String name;
        private String mapTo;

        public ContextRule(String name, String mapTo) {
            if (name == null) {
                throw new NullPointerException("Name is null");
            }
            this.name = name;
            this.mapTo = mapTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContextRule)) {
                return false;
            }
            ContextRule contextRule = (ContextRule)o;
            return this.name.equals(contextRule.name);
        }

        public String getMapTo() {
            return this.mapTo;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean isMappingDefined() {
            return this.mapTo != null;
        }
    }
}

