/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.report.modules.gui.config.editor.AbstractKeyEditor;
import org.jfree.report.modules.gui.config.model.EnumConfigDescriptionEntry;
import org.jfree.report.util.ReportConfiguration;

public class EnumKeyEditor
extends AbstractKeyEditor {
    private final JComboBox content;
    private final JLabel entryLabel;
    private final List options;
    private final JPanel entryLabelCarrier;

    public EnumKeyEditor(ReportConfiguration config, EnumConfigDescriptionEntry entry, String displayName) {
        super(config, entry);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(5, 0));
        this.entryLabel = new JLabel(displayName);
        this.entryLabel.setToolTipText(entry.getDescription());
        this.entryLabelCarrier = new JPanel();
        this.entryLabelCarrier.setLayout(new BorderLayout());
        this.entryLabelCarrier.add(this.entryLabel);
        contentPane.add((Component)this.entryLabelCarrier, "West");
        this.options = Arrays.asList(entry.getOptions());
        this.content = new JComboBox<String>(entry.getOptions());
        this.content.addItemListener(new ComboBoxSelectionHandler());
        contentPane.add((Component)this.content, "Center");
        this.setContentPane(contentPane);
        this.reset();
    }

    public int getLabelWidth() {
        Dimension prefSize = this.entryLabel.getPreferredSize();
        if (prefSize != null) {
            return prefSize.width;
        }
        return 0;
    }

    public void reset() {
        this.content.setSelectedItem(this.loadValue());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.content.setEnabled(enabled);
    }

    public void setLabelWidth(int width) {
        Dimension prefSize = this.entryLabel.getPreferredSize();
        this.entryLabelCarrier.setPreferredSize(new Dimension(width, prefSize.height));
    }

    public void store() {
        if (this.isValidInput()) {
            if (this.isEnabled()) {
                this.storeValue((String)this.content.getSelectedItem());
            } else {
                this.deleteValue();
            }
        }
    }

    protected void validateInput() {
        this.setValidInput(this.options.contains(this.content.getSelectedItem()));
    }

    private class ComboBoxSelectionHandler
    implements ItemListener {
        ComboBoxSelectionHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            EnumKeyEditor.this.validateInput();
        }
    }
}

