/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class VerticalLayout
implements LayoutManager {
    private final boolean useSizeFromParent;

    public VerticalLayout() {
        this(true);
    }

    public VerticalLayout(boolean useParent) {
        this.useSizeFromParent = useParent;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public boolean isUseSizeFromParent() {
        return this.useSizeFromParent;
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int width;
            Insets ins = parent.getInsets();
            int insHorizontal = ins.left + ins.right;
            if (this.isUseSizeFromParent()) {
                Rectangle bounds = parent.getBounds();
                width = bounds.width - insHorizontal;
            } else {
                width = this.preferredLayoutSize((Container)parent).width - insHorizontal;
            }
            Component[] comps = parent.getComponents();
            int y = ins.top;
            int i = 0;
            while (i < comps.length) {
                Component c = comps[i];
                if (c.isVisible()) {
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(0, y, width, dim.height);
                    y += dim.height;
                }
                ++i;
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets ins = parent.getInsets();
            Component[] comps = parent.getComponents();
            int height = 0;
            int width = 0;
            int i = 0;
            while (i < comps.length) {
                if (comps[i].isVisible()) {
                    Dimension min = comps[i].getMinimumSize();
                    height += min.height;
                    if (min.width > width) {
                        width = min.width;
                    }
                }
                ++i;
            }
            Dimension dimension = new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
            Object var4_10 = null;
            return dimension;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets ins = parent.getInsets();
            Component[] comps = parent.getComponents();
            int height = 0;
            int width = 0;
            int i = 0;
            while (i < comps.length) {
                if (comps[i].isVisible()) {
                    Dimension pref = comps[i].getPreferredSize();
                    height += pref.height;
                    if (pref.width > width) {
                        width = pref.width;
                    }
                }
                ++i;
            }
            Dimension dimension = new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
            Object var4_10 = null;
            return dimension;
        }
    }

    public void removeLayoutComponent(Component comp) {
    }
}

