/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jfree.report.modules.gui.config.model.ClassConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionModel;
import org.jfree.report.modules.gui.config.model.EnumConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.TextConfigDescriptionEntry;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.ui.action.AbstractActionDowngrade;
import org.jfree.ui.action.ActionButton;
import org.jfree.ui.action.ActionRadioButton;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.ResourceBundleSupport;

public class ConfigDescriptionEditor
extends JFrame {
    private static final String CLASS_DETAIL_EDITOR_NAME = "Class";
    private static final String ENUM_DETAIL_EDITOR_NAME = "Enum";
    private static final String TEXT_DETAIL_EDITOR_NAME = "Text";
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_CLASS = 1;
    private static final int TYPE_ENUM = 2;
    private ActionRadioButton rbText;
    private ActionRadioButton rbClass;
    private ActionRadioButton rbEnum;
    private ConfigDescriptionModel model;
    private JTextField keyNameField;
    private JTextArea descriptionField;
    private JCheckBox globalField;
    private JCheckBox hiddenField;
    private JTextField baseClassField;
    private JLabel baseClassValidateMessage;
    private JTextField enumEntryEditField;
    private DefaultListModel enumEntryListModel;
    private ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.config.resources/config-resources");
    private CardLayout detailManager;
    private JPanel detailManagerPanel;
    private final JPanel detailEditorPane;
    private JList entryList;
    private JList enumEntryList;
    private ConfigDescriptionEntry selectedEntry;
    private final JFileChooser fileChooser;
    private JLabel statusHolder;
    private int type;
    static /* synthetic */ Class class$java$lang$Object;

    public ConfigDescriptionEditor() {
        this.setTitle(this.resources.getString("config-description-editor.title"));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.detailEditorPane = this.createEditPane();
        JSplitPane splitPane = new JSplitPane(1, this.createEntryList(), this.detailEditorPane);
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)this.createButtonPane(), "South");
        JPanel cPaneStatus = new JPanel();
        cPaneStatus.setLayout(new BorderLayout());
        cPaneStatus.add((Component)contentPane, "Center");
        cPaneStatus.add((Component)this.createStatusBar(), "South");
        this.setContentPane(cPaneStatus);
        this.setEntryType(0);
        this.setSelectedEntry(null);
        this.fileChooser = new JFileChooser();
        this.fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(this.resources.getString("config-description-editor.xml-files"), ".xml"));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.setStatusText(this.resources.getString("config-description-editor.welcome"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConfigDescriptionEditor.this.attempExit();
            }
        });
    }

    protected void attempExit() {
        System.exit(0);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private JPanel createButtonPane() {
        CloseAction closeAction = new CloseAction();
        SaveAction saveAction = new SaveAction();
        LoadAction loadAction = new LoadAction();
        ImportAction importAction = new ImportAction();
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel buttonHolder = new JPanel();
        buttonHolder.setLayout(new GridLayout(1, 4));
        buttonHolder.add((Component)new ActionButton((Action)((Object)importAction)));
        buttonHolder.add((Component)new ActionButton((Action)((Object)loadAction)));
        buttonHolder.add((Component)new ActionButton((Action)((Object)saveAction)));
        buttonHolder.add((Component)new ActionButton((Action)((Object)closeAction)));
        panel.add(buttonHolder);
        return panel;
    }

    private JPanel createClassEditor() {
        this.baseClassField = new JTextField();
        this.baseClassValidateMessage = new JLabel(" ");
        JLabel textLabel = new JLabel(this.resources.getString("config-description-editor.baseclass"));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)textLabel, "West");
        panel.add((Component)this.baseClassField, "Center");
        panel.add((Component)this.baseClassValidateMessage, "South");
        JPanel carrier = new JPanel();
        carrier.setLayout(new BorderLayout());
        carrier.add((Component)panel, "North");
        return carrier;
    }

    private JPanel createDetailEditorPanel() {
        JLabel keyNameLabel = new JLabel(this.resources.getString("config-description-editor.keyname"));
        JLabel descriptionLabel = new JLabel(this.resources.getString("config-description-editor.description"));
        JLabel typeLabel = new JLabel(this.resources.getString("config-description-editor.type"));
        JLabel globalLabel = new JLabel(this.resources.getString("config-description-editor.global"));
        JLabel hiddenLabel = new JLabel(this.resources.getString("config-description-editor.hidden"));
        this.hiddenField = new JCheckBox();
        this.globalField = new JCheckBox();
        String font = ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.config.EditorFont", "Monospaced");
        int fontSize = StringUtil.parseInt(ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.config.EditorFontSize"), 12);
        this.descriptionField = new JTextArea();
        this.descriptionField.setFont(new Font(font, 0, fontSize));
        this.descriptionField.setLineWrap(true);
        this.descriptionField.setWrapStyleWord(true);
        this.keyNameField = new JTextField();
        JPanel enumerationEditor = this.createEnumerationEditor();
        JPanel textEditor = this.createTextEditor();
        JPanel classEditor = this.createClassEditor();
        this.detailManagerPanel = new JPanel();
        this.detailManager = new CardLayout();
        this.detailManagerPanel.setLayout(this.detailManager);
        this.detailManagerPanel.add((Component)classEditor, CLASS_DETAIL_EDITOR_NAME);
        this.detailManagerPanel.add((Component)textEditor, TEXT_DETAIL_EDITOR_NAME);
        this.detailManagerPanel.add((Component)enumerationEditor, ENUM_DETAIL_EDITOR_NAME);
        JPanel commonEntryEditorPanel = new JPanel();
        commonEntryEditorPanel.setLayout(new GridBagLayout());
        commonEntryEditorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)keyNameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.keyNameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)descriptionLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        gbc.ipady = 120;
        commonEntryEditorPanel.add((Component)new JScrollPane(this.descriptionField, 22, 31), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)globalLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.globalField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)hiddenLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.hiddenField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        commonEntryEditorPanel.add((Component)typeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.createTypeSelectionPane(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        commonEntryEditorPanel.add((Component)this.detailManagerPanel, gbc);
        return commonEntryEditorPanel;
    }

    private JPanel createEditPane() {
        UpdateAction updateAction = new UpdateAction();
        CancelAction cancelAction = new CancelAction();
        JPanel buttonHolder = new JPanel();
        buttonHolder.setLayout(new GridLayout(1, 4));
        buttonHolder.add((Component)new ActionButton((Action)((Object)cancelAction)));
        buttonHolder.add((Component)new ActionButton((Action)((Object)updateAction)));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonPanel.add(buttonHolder);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createDetailEditorPanel(), "Center");
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private JPanel createEntryList() {
        AddEntryAction addEntryAction = new AddEntryAction();
        RemoveEntryAction removeEntryAction = new RemoveEntryAction();
        this.model = new ConfigDescriptionModel();
        this.entryList = new JList(this.model);
        this.entryList.addListSelectionListener(new ConfigListSelectionListener());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)((Object)addEntryAction));
        toolbar.add((Action)((Object)removeEntryAction));
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(200, 0));
        panel.setLayout(new BorderLayout());
        panel.add((Component)toolbar, "North");
        panel.add((Component)new JScrollPane(this.entryList, 20, 30), "Center");
        return panel;
    }

    private JPanel createEnumerationEditor() {
        this.enumEntryEditField = new JTextField();
        this.enumEntryListModel = new DefaultListModel();
        this.enumEntryList = new JList(this.enumEntryListModel);
        this.enumEntryList.addListSelectionListener(new EnumerationListSelectionHandler());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)this.enumEntryEditField, "North");
        listPanel.add((Component)new JScrollPane(this.enumEntryList), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(5, 1));
        buttonPanel.add((Component)new ActionButton((Action)((Object)new AddEnumEntryAction())));
        buttonPanel.add((Component)new ActionButton((Action)((Object)new RemoveEnumEntryAction())));
        buttonPanel.add((Component)new ActionButton((Action)((Object)new UpdateEnumEntryAction())));
        buttonPanel.add(new JPanel());
        buttonPanel.add((Component)new ActionButton((Action)((Object)new SetBooleanEnumEntryAction())));
        JPanel buttonCarrier = new JPanel();
        buttonCarrier.setLayout(new FlowLayout(1, 0, 0));
        buttonCarrier.add(buttonPanel);
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BorderLayout());
        editorPanel.add((Component)listPanel, "Center");
        editorPanel.add((Component)buttonCarrier, "East");
        return editorPanel;
    }

    protected JPanel createStatusBar() {
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        statusPane.setMinimumSize(this.statusHolder.getPreferredSize());
        statusPane.add((Component)this.statusHolder, "West");
        return statusPane;
    }

    private JPanel createTextEditor() {
        JLabel textLabel = new JLabel(this.resources.getString("config-description-editor.text-editor-message"));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(textLabel);
        return panel;
    }

    private JPanel createTypeSelectionPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, 1));
        this.rbText = new ActionRadioButton((Action)((Object)new SelectTypeAction(this.resources.getString("config-description-editor.type-text"), 0)));
        this.rbClass = new ActionRadioButton((Action)((Object)new SelectTypeAction(this.resources.getString("config-description-editor.type-class"), 1)));
        this.rbEnum = new ActionRadioButton((Action)((Object)new SelectTypeAction(this.resources.getString("config-description-editor.type-enum"), 2)));
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.rbText);
        bg.add((AbstractButton)this.rbClass);
        bg.add((AbstractButton)this.rbEnum);
        panel.add((Component)this.rbText);
        panel.add((Component)this.rbClass);
        panel.add((Component)this.rbEnum);
        return panel;
    }

    private void deepEnable(Component comp, boolean state) {
        comp.setEnabled(state);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] childs = cont.getComponents();
            int i = 0;
            while (i < childs.length) {
                this.deepEnable(childs[i], state);
                ++i;
            }
        }
    }

    protected JList getEntryList() {
        return this.entryList;
    }

    protected int getEntryType() {
        return this.type;
    }

    protected JTextField getEnumEntryEditField() {
        return this.enumEntryEditField;
    }

    protected JList getEnumEntryList() {
        return this.enumEntryList;
    }

    protected DefaultListModel getEnumEntryListModel() {
        return this.enumEntryListModel;
    }

    protected ConfigDescriptionModel getModel() {
        return this.model;
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    protected ConfigDescriptionEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    protected String getStatusText() {
        return this.statusHolder.getText();
    }

    protected void load() {
        block2: {
            this.fileChooser.setVisible(true);
            int option = this.fileChooser.showOpenDialog(this);
            if (option != 0) break block2;
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.fileChooser.getSelectedFile()));
                this.model.load(in);
                ((InputStream)in).close();
                this.model.sort();
                this.setStatusText(this.resources.getString("config-description-editor.load-complete"));
            }
            catch (Exception ioe) {
                Log.debug("Load Failed", ioe);
                String message = MessageFormat.format(this.resources.getString("config-description-editor.load-failed"), ioe.getMessage());
                this.setStatusText(message);
            }
        }
    }

    public static void main(String[] args) {
        ConfigDescriptionEditor ed = new ConfigDescriptionEditor();
        ed.pack();
        ((Component)ed).setVisible(true);
    }

    protected void save() {
        block2: {
            this.fileChooser.setVisible(true);
            int option = this.fileChooser.showSaveDialog(this);
            if (option != 0) break block2;
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.fileChooser.getSelectedFile()));
                this.model.save(out, "ISO-8859-1");
                ((OutputStream)out).close();
                this.setStatusText(this.resources.getString("config-description-editor.save-complete"));
            }
            catch (Exception ioe) {
                Log.debug("Failed", ioe);
                String message = MessageFormat.format(this.resources.getString("config-description-editor.save-failed"), ioe.getMessage());
                this.setStatusText(message);
            }
        }
    }

    protected void setEntryType(int type) {
        this.type = type;
        if (type == 1) {
            this.detailManager.show(this.detailManagerPanel, CLASS_DETAIL_EDITOR_NAME);
            this.rbClass.setSelected(true);
        } else if (type == 2) {
            this.detailManager.show(this.detailManagerPanel, ENUM_DETAIL_EDITOR_NAME);
            this.rbEnum.setSelected(true);
        } else {
            this.detailManager.show(this.detailManagerPanel, TEXT_DETAIL_EDITOR_NAME);
            this.rbText.setSelected(true);
        }
        this.invalidate();
    }

    protected void setSelectedEntry(ConfigDescriptionEntry selectedEntry) {
        this.selectedEntry = selectedEntry;
        this.enumEntryEditField.setText("");
        this.enumEntryListModel.clear();
        this.baseClassField.setText("");
        if (this.selectedEntry == null) {
            this.deepEnable(this.detailEditorPane, false);
        } else {
            this.deepEnable(this.detailEditorPane, true);
            this.keyNameField.setText(selectedEntry.getKeyName());
            this.globalField.setSelected(selectedEntry.isGlobal());
            this.hiddenField.setSelected(selectedEntry.isHidden());
            this.descriptionField.setText(selectedEntry.getDescription());
            if (selectedEntry instanceof ClassConfigDescriptionEntry) {
                ClassConfigDescriptionEntry ce = (ClassConfigDescriptionEntry)selectedEntry;
                this.setEntryType(1);
                if (ce.getBaseClass() != null) {
                    this.baseClassField.setText(ce.getBaseClass().getName());
                }
            } else if (selectedEntry instanceof EnumConfigDescriptionEntry) {
                EnumConfigDescriptionEntry en = (EnumConfigDescriptionEntry)selectedEntry;
                String[] enums = en.getOptions();
                int i = 0;
                while (i < enums.length) {
                    this.enumEntryListModel.addElement(enums[i]);
                    ++i;
                }
                this.setEntryType(2);
            } else {
                this.setEntryType(0);
            }
        }
    }

    protected void setStatusText(String text) {
        this.statusHolder.setText(text);
    }

    protected void updateSelectedEntry() {
        ConfigDescriptionEntry entry;
        switch (this.getEntryType()) {
            case 1: {
                ClassConfigDescriptionEntry ce = new ClassConfigDescriptionEntry(this.keyNameField.getText());
                ce.setDescription(this.descriptionField.getText());
                ce.setGlobal(this.globalField.isSelected());
                ce.setHidden(this.hiddenField.isSelected());
                try {
                    Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(this.baseClassField.getText());
                    ce.setBaseClass(c);
                }
                catch (Exception exception) {
                    Log.debug("Class is invalid; defaulting to Object.class");
                    ce.setBaseClass(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ConfigDescriptionEditor.class$("java.lang.Object")));
                }
                entry = ce;
                break;
            }
            case 2: {
                EnumConfigDescriptionEntry ece = new EnumConfigDescriptionEntry(this.keyNameField.getText());
                ece.setDescription(this.descriptionField.getText());
                ece.setGlobal(this.globalField.isSelected());
                ece.setHidden(this.hiddenField.isSelected());
                String[] enumEntries = new String[this.enumEntryListModel.getSize()];
                int i = 0;
                while (i < this.enumEntryListModel.getSize()) {
                    enumEntries[i] = String.valueOf(this.enumEntryListModel.get(i));
                    ++i;
                }
                ece.setOptions(enumEntries);
                entry = ece;
                break;
            }
            default: {
                TextConfigDescriptionEntry te = new TextConfigDescriptionEntry(this.keyNameField.getText());
                te.setDescription(this.descriptionField.getText());
                te.setGlobal(this.globalField.isSelected());
                te.setHidden(this.hiddenField.isSelected());
                entry = te;
            }
        }
        if (this.model.contains(entry)) {
            this.model.remove(entry);
        }
        this.model.remove(this.selectedEntry);
        this.model.add(entry);
        this.model.sort();
        this.entryList.setSelectedIndex(this.model.indexOf(entry));
        this.setStatusText(this.resources.getString("config-description-editor.update-complete"));
    }

    private class CloseAction
    extends AbstractActionDowngrade {
        public CloseAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.exit.name"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.attempExit();
        }
    }

    private class SaveAction
    extends AbstractActionDowngrade {
        public SaveAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.save.name"));
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.save.small-icon"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.save();
        }
    }

    private class ImportAction
    extends AbstractActionDowngrade {
        public ImportAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.import.name"));
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.import.small-icon"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionModel model = ConfigDescriptionEditor.this.getModel();
            model.importFromConfig(ReportConfiguration.getGlobalConfig());
            model.sort();
            ConfigDescriptionEditor.this.setStatusText(ConfigDescriptionEditor.this.getResources().getString("config-description-editor.import-complete"));
        }
    }

    private class AddEntryAction
    extends AbstractActionDowngrade {
        public AddEntryAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.add-entry.name"));
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.add-entry.small-icon"));
        }

        public void actionPerformed(ActionEvent e) {
            TextConfigDescriptionEntry te = new TextConfigDescriptionEntry(ConfigDescriptionEditor.this.getResources().getString("config-description-editor.unnamed-entry"));
            ConfigDescriptionModel model = ConfigDescriptionEditor.this.getModel();
            model.add(te);
            ConfigDescriptionEditor.this.getEntryList().setSelectedIndex(model.getSize() - 1);
        }
    }

    private class RemoveEntryAction
    extends AbstractActionDowngrade {
        public RemoveEntryAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.remove-entry.name"));
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.remove-entry.small-icon"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectedEntries = ConfigDescriptionEditor.this.getEntryList().getSelectedIndices();
            ConfigDescriptionModel model = ConfigDescriptionEditor.this.getModel();
            int i = selectedEntries.length - 1;
            while (i >= 0) {
                model.remove(model.get(selectedEntries[i]));
                --i;
            }
            ConfigDescriptionEditor.this.getEntryList().clearSelection();
        }
    }

    private class LoadAction
    extends AbstractActionDowngrade {
        public LoadAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.load.name"));
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ConfigDescriptionEditor.this.getResources().getIcon("action.load.small-icon"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.load();
        }
    }

    private class UpdateAction
    extends AbstractActionDowngrade {
        public UpdateAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.update.name"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.updateSelectedEntry();
        }
    }

    private class CancelAction
    extends AbstractActionDowngrade {
        public CancelAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.cancel.name"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEntry ce = ConfigDescriptionEditor.this.getSelectedEntry();
            ConfigDescriptionEditor.this.setSelectedEntry(null);
            ConfigDescriptionEditor.this.setSelectedEntry(ce);
        }
    }

    private class SelectTypeAction
    extends AbstractActionDowngrade {
        private final int type;

        public SelectTypeAction(String name, int type) {
            ((AbstractAction)((Object)this)).putValue("Name", name);
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.setEntryType(this.type);
        }
    }

    private class ConfigListSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (ConfigDescriptionEditor.this.getEntryList().getSelectedIndex() == -1) {
                ConfigDescriptionEditor.this.setSelectedEntry(null);
            } else {
                ConfigDescriptionEditor.this.setSelectedEntry(ConfigDescriptionEditor.this.getModel().get(ConfigDescriptionEditor.this.getEntryList().getSelectedIndex()));
            }
        }
    }

    private class EnumerationListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (ConfigDescriptionEditor.this.getEnumEntryList().getSelectedIndex() == -1) {
                ConfigDescriptionEditor.this.getEnumEntryEditField().setText("");
            } else {
                ConfigDescriptionEditor.this.getEnumEntryEditField().setText((String)ConfigDescriptionEditor.this.getEnumEntryListModel().get(ConfigDescriptionEditor.this.getEnumEntryList().getSelectedIndex()));
            }
        }
    }

    private class SetBooleanEnumEntryAction
    extends AbstractActionDowngrade {
        public SetBooleanEnumEntryAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.boolean.name"));
        }

        public void actionPerformed(ActionEvent e) {
            DefaultListModel enumEntryListModel = ConfigDescriptionEditor.this.getEnumEntryListModel();
            enumEntryListModel.clear();
            ConfigDescriptionEditor.this.getEnumEntryEditField().setText("");
            enumEntryListModel.addElement("true");
            enumEntryListModel.addElement("false");
        }
    }

    private class AddEnumEntryAction
    extends AbstractActionDowngrade {
        public AddEnumEntryAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.add-enum-entry.name"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigDescriptionEditor.this.getEnumEntryListModel().addElement(ConfigDescriptionEditor.this.getEnumEntryEditField().getText());
        }
    }

    private class RemoveEnumEntryAction
    extends AbstractActionDowngrade {
        public RemoveEnumEntryAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.remove-enum-entry.name"));
        }

        public void actionPerformed(ActionEvent e) {
            JList enumEntryList = ConfigDescriptionEditor.this.getEnumEntryList();
            DefaultListModel enumEntryListModel = ConfigDescriptionEditor.this.getEnumEntryListModel();
            int[] selectedEntries = enumEntryList.getSelectedIndices();
            int i = selectedEntries.length - 1;
            while (i >= 0) {
                enumEntryListModel.remove(selectedEntries[i]);
                --i;
            }
            enumEntryList.clearSelection();
        }
    }

    private class UpdateEnumEntryAction
    extends AbstractActionDowngrade {
        public UpdateEnumEntryAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigDescriptionEditor.this.getResources().getString("action.update-enum-entry.name"));
        }

        public void actionPerformed(ActionEvent e) {
            int idx = ConfigDescriptionEditor.this.getEnumEntryList().getSelectedIndex();
            if (idx == -1) {
                ConfigDescriptionEditor.this.getEnumEntryListModel().addElement(ConfigDescriptionEditor.this.getEnumEntryEditField().getText());
            } else {
                ConfigDescriptionEditor.this.getEnumEntryListModel().setElementAt(ConfigDescriptionEditor.this.getEnumEntryEditField().getText(), idx);
            }
        }
    }
}

