/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base.components;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jfree.report.util.EncodingSupport;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class EncodingComboBoxModel
implements ComboBoxModel {
    private static final String ENCODING_DEFAULT_DESCRIPTION = "[no description]";
    public static final String AVAILABLE_ENCODINGS = "org.jfree.report.modules.gui.base.EncodingsAvailable";
    public static final String AVAILABLE_ENCODINGS_ALL = "all";
    public static final String AVAILABLE_ENCODINGS_FILE = "file";
    public static final String AVAILABLE_ENCODINGS_NONE = "none";
    public static final String ENCODINGS_DEFINITION_FILE = "org.jfree.report.modules.gui.base.EncodingsFile";
    public static final String ENCODINGS_DEFINITION_FILE_DEFAULT = "org/jfree/report/modules/gui/base/components/jfreereport-encodings.properties";
    private static Properties defaultEncodings;
    private final ArrayList encodings = new ArrayList();
    private ArrayList listDataListeners = null;
    private int selectedIndex = -1;
    private Object selectedObject;
    static /* synthetic */ Class class$org$jfree$report$modules$gui$base$components$EncodingComboBoxModel;

    private static void addBasicEncodings() {
        ((Hashtable)defaultEncodings).put("ASCII", "American Standard Code for Information Interchange");
        ((Hashtable)defaultEncodings).put("Cp1252", "Windows Latin-1");
        ((Hashtable)defaultEncodings).put("ISO-8859-1", "Latin alphabet No. 1");
        ((Hashtable)defaultEncodings).put("ISO-8859-15", "Latin alphabet No. 9, 'Euro' enabled");
        ((Hashtable)defaultEncodings).put("UTF-8", "8 Bit UCS Transformation Format");
        ((Hashtable)defaultEncodings).put("UTF-16", "16 Bit UCS Transformation Format");
        ((Hashtable)defaultEncodings).put("Cp1250", "Windows Eastern Europe");
        ((Hashtable)defaultEncodings).put("Cp1251", "Windows Russian (Cyrillic)");
        ((Hashtable)defaultEncodings).put("Cp1253", "Windows Greek");
        ((Hashtable)defaultEncodings).put("Cp1254", "Windows Turkish");
        ((Hashtable)defaultEncodings).put("Cp1255", "Windows Hebrew");
        ((Hashtable)defaultEncodings).put("Cp1256", "Windows Arabic");
        ((Hashtable)defaultEncodings).put("Cp1257", "Windows Baltic");
        ((Hashtable)defaultEncodings).put("Cp1258", "Windows Vietnamese");
        ((Hashtable)defaultEncodings).put("ISO-8859-2", "Latin alphabet No. 2");
        ((Hashtable)defaultEncodings).put("ISO-8859-3", "Latin alphabet No. 3");
        ((Hashtable)defaultEncodings).put("ISO-8859-4", "Latin alphabet No. 4");
        ((Hashtable)defaultEncodings).put("ISO-8859-5", "Latin/Cyrillic Alphabet");
        ((Hashtable)defaultEncodings).put("ISO-8859-6", "Latin/Arabic Alphabet");
        ((Hashtable)defaultEncodings).put("ISO-8859-7", "Latin/Greek Alphabet");
        ((Hashtable)defaultEncodings).put("ISO-8859-8", "Latin/Hebrew Alphabet");
        ((Hashtable)defaultEncodings).put("ISO-8859-9", "Latin alphabet No. 5");
        ((Hashtable)defaultEncodings).put("ISO-8859-13", "Latin alphabet No. 7");
        ((Hashtable)defaultEncodings).put("MS932", "Windows Japanese");
        ((Hashtable)defaultEncodings).put("EUC-JP", "JISX 0201, 0208 and 0212, EUC encoding Japanese");
        ((Hashtable)defaultEncodings).put("EUC-JP-LINUX", "JISX 0201, 0208, EUC encoding Japanese");
        ((Hashtable)defaultEncodings).put("SJIS", "Shift-JIS, Japanese");
        ((Hashtable)defaultEncodings).put("ISO-2022-JP", "JIS X 0201, 0208, in ISO 2002 form, Japanese");
        ((Hashtable)defaultEncodings).put("MS936", "Windows Simplified Chinese");
        ((Hashtable)defaultEncodings).put("GB18030", "Simplified Chinese, PRC standard");
        ((Hashtable)defaultEncodings).put("EUC_CN", "GB2312, EUC encoding, Simplified Chinese");
        ((Hashtable)defaultEncodings).put("GB2312", "GB2312, EUC encoding, Simplified Chinese");
        ((Hashtable)defaultEncodings).put("GBK", "GBK, Simplified Chinese");
        ((Hashtable)defaultEncodings).put("ISCII91", "ISCII encoding of Indic scripts");
        ((Hashtable)defaultEncodings).put("ISO-2022-CN-GB", "GB2312 in ISO 2022 CN form, Simplified Chinese");
        ((Hashtable)defaultEncodings).put("MS949", "Windows Korean");
        ((Hashtable)defaultEncodings).put("EUC_KR", "KS C 5601, EUC encoding, Korean");
        ((Hashtable)defaultEncodings).put("ISO-2022-KR", "ISO 2022 KR, Korean");
        ((Hashtable)defaultEncodings).put("MS950", "Windows Traditional Chinese");
        ((Hashtable)defaultEncodings).put("EUC-TW", "CNS 11643 (Plane 1-3), EUC encoding, Traditional Chinese");
        ((Hashtable)defaultEncodings).put("ISO-2022-CN-CNS", "CNS 11643 in ISO 2022 CN form, Traditional Chinese");
        ((Hashtable)defaultEncodings).put("Big5", "Big5, Traditional Chinese");
        ((Hashtable)defaultEncodings).put("Big5-HKSCS", "Big5 with Hong Kong extensions, Traditional Chinese");
        ((Hashtable)defaultEncodings).put("TIS-620", "TIS 620, Thai");
        ((Hashtable)defaultEncodings).put("KOI8-R", "KOI8-R, Russian");
    }

    public boolean addEncoding(String name, String description) {
        if (!EncodingSupport.isSupportedEncoding(name)) {
            return false;
        }
        this.encodings.add(new EncodingCarrier(name, description));
        this.fireContentsChanged();
        return true;
    }

    public void addEncodingUnchecked(String name, String description) {
        this.encodings.add(new EncodingCarrier(name, description));
        this.fireContentsChanged();
    }

    private static void addExtendedEncodings() {
        ((Hashtable)defaultEncodings).put("Big5_Solaris", "Big5 with seven additional Hanzi ideograph character mappings");
        ((Hashtable)defaultEncodings).put("Cp037", "USA, Canada (Bilingual, French), Netherlands, Portugal, Brazil, Australia");
        ((Hashtable)defaultEncodings).put("Cp273", "IBM Austria, Germany");
        ((Hashtable)defaultEncodings).put("Cp277", "IBM Denmark, Norway");
        ((Hashtable)defaultEncodings).put("Cp278", "IBM Finland, Sweden");
        ((Hashtable)defaultEncodings).put("Cp280", "IBM Italy");
        ((Hashtable)defaultEncodings).put("Cp284", "IBM Catalan/Spain, Spanish Latin America");
        ((Hashtable)defaultEncodings).put("Cp285", "IBM United Kingdom, Ireland");
        ((Hashtable)defaultEncodings).put("Cp297", "IBM France");
        ((Hashtable)defaultEncodings).put("Cp420", "IBM Arabic");
        ((Hashtable)defaultEncodings).put("Cp424", "IBM Hebrew");
        ((Hashtable)defaultEncodings).put("Cp437", "MS-DOS United States, Australia, New Zealand, South Africa");
        ((Hashtable)defaultEncodings).put("Cp500", "EBCDIC 500V1");
        ((Hashtable)defaultEncodings).put("Cp737", "PC Greek");
        ((Hashtable)defaultEncodings).put("Cp775", "PC Baltik");
        ((Hashtable)defaultEncodings).put("Cp838", "IBM Thailand extended SBCS");
        ((Hashtable)defaultEncodings).put("Cp850", "MS-DOS Latin-1");
        ((Hashtable)defaultEncodings).put("Cp852", "MS-DOS Latin 2");
        ((Hashtable)defaultEncodings).put("Cp855", "IBM Cyrillic");
        ((Hashtable)defaultEncodings).put("Cp856", "IBM Hebrew");
        ((Hashtable)defaultEncodings).put("Cp857", "IBM Turkish");
        ((Hashtable)defaultEncodings).put("Cp858", "MS-DOS Latin-1 with Euro character");
        ((Hashtable)defaultEncodings).put("Cp860", "MS-DOS Portuguese");
        ((Hashtable)defaultEncodings).put("Cp861", "MS-DOS Icelandic");
        ((Hashtable)defaultEncodings).put("Cp862", "PC Hebrew");
        ((Hashtable)defaultEncodings).put("Cp863", "MS-DOS Canadian French");
        ((Hashtable)defaultEncodings).put("Cp864", "PC Arabic");
        ((Hashtable)defaultEncodings).put("Cp865", "MS-DOS Nordic");
        ((Hashtable)defaultEncodings).put("Cp866", "MS-DOS Russian");
        ((Hashtable)defaultEncodings).put("Cp868", "MS-DOS Pakistan");
        ((Hashtable)defaultEncodings).put("Cp869", "IBM Modern Greek");
        ((Hashtable)defaultEncodings).put("Cp870", "IBM Multilingual Latin-2");
        ((Hashtable)defaultEncodings).put("Cp871", "IBM Iceland");
        ((Hashtable)defaultEncodings).put("Cp874", "IBM Thai");
        ((Hashtable)defaultEncodings).put("Cp875", "IBM Greek");
        ((Hashtable)defaultEncodings).put("Cp918", "IBM Pakistan (Urdu)");
        ((Hashtable)defaultEncodings).put("Cp921", "IBM Lativa, Lithuania (AIX, DOS)");
        ((Hashtable)defaultEncodings).put("Cp922", "IBM Estonia (AIX, DOS)");
        ((Hashtable)defaultEncodings).put("Cp930", "Japanese Katakana-Kanji mixed with 4370 UDC, superset of 5026");
        ((Hashtable)defaultEncodings).put("Cp933", "Korean mixed with 1880 UDC, superset of 5029");
        ((Hashtable)defaultEncodings).put("Cp935", "Simplified Chinese mixed with 1880 UDC, superset of 5031");
        ((Hashtable)defaultEncodings).put("Cp937", "Traditional Chinsese Hostmixed with 6204 UDC, superset of 5033");
        ((Hashtable)defaultEncodings).put("Cp939", "Japanese Latin Kanji mixed with 4370 UDC, superset of 5035");
        ((Hashtable)defaultEncodings).put("Cp942", "IBM OS/2 Japanese, superset of Cp932");
        ((Hashtable)defaultEncodings).put("Cp942C", "Variant of Cp942: IBM OS/2 Japanese, superset of Cp932");
        ((Hashtable)defaultEncodings).put("Cp943", "IBM OS/2 Japanese, superset of Cp932 and Shift-JIS");
        ((Hashtable)defaultEncodings).put("Cp943C", "Variant of Cp943: IBM OS/2 Japanese, superset of Cp932 and Shift-JIS");
        ((Hashtable)defaultEncodings).put("Cp948", "IBM OS/2 Chinese (Taiwan) superset of Cp938");
        ((Hashtable)defaultEncodings).put("Cp949", "PC Korean");
        ((Hashtable)defaultEncodings).put("Cp949C", "Variant of Cp949: PC Korean");
        ((Hashtable)defaultEncodings).put("Cp950", "PC Chinese (Hong Kong, Taiwan)");
        ((Hashtable)defaultEncodings).put("Cp964", "AIX Chinese (Taiwan)");
        ((Hashtable)defaultEncodings).put("Cp970", "AIX Korean");
        ((Hashtable)defaultEncodings).put("Cp1006", "IBM AIX Parkistan (Urdu)");
        ((Hashtable)defaultEncodings).put("Cp1025", "IBM Multilingual Cyrillic: Bulgaria, Bosnia, Herzegovinia, Macedonia (FYR)");
        ((Hashtable)defaultEncodings).put("Cp1026", "IBM Latin-5, Turkey");
        ((Hashtable)defaultEncodings).put("Cp1046", "IBM Arabic Windows");
        ((Hashtable)defaultEncodings).put("Cp1097", "IBM Iran (Farsi)/Persian");
        ((Hashtable)defaultEncodings).put("Cp1098", "IBM Iran (Farsi)/Persian (PC)");
        ((Hashtable)defaultEncodings).put("Cp1112", "IBM Lativa, Lithuania");
        ((Hashtable)defaultEncodings).put("Cp1122", "IBM Estonia");
        ((Hashtable)defaultEncodings).put("Cp1123", "IBM Ukraine");
        ((Hashtable)defaultEncodings).put("Cp1124", "IBM AIX Ukraine");
        ((Hashtable)defaultEncodings).put("Cp1140", "USA, Canada (Bilingual, French), Netherlands, Portugal, Brazil, Australia (with Euro)");
        ((Hashtable)defaultEncodings).put("Cp1141", "IBM Austria, Germany (Euro enabled)");
        ((Hashtable)defaultEncodings).put("Cp1142", "IBM Denmark, Norway (Euro enabled)");
        ((Hashtable)defaultEncodings).put("Cp1143", "IBM Finland, Sweden (Euro enabled)");
        ((Hashtable)defaultEncodings).put("Cp1144", "IBM Italy (Euro enabled)");
        ((Hashtable)defaultEncodings).put("Cp1145", "IBM Catalan/Spain, Spanish Latin America (with Euro)");
        ((Hashtable)defaultEncodings).put("Cp1146", "IBM United Kingdom, Ireland (with Euro)");
        ((Hashtable)defaultEncodings).put("Cp1147", "IBM France (with Euro)");
        ((Hashtable)defaultEncodings).put("Cp1148", "IBM EBCDIC 500V1 (with Euro)");
        ((Hashtable)defaultEncodings).put("Cp1149", "IBM Iceland (with Euro)");
        ((Hashtable)defaultEncodings).put("Cp1381", "IBM OS/2, DOS People's Republic of Chine (PRC)");
        ((Hashtable)defaultEncodings).put("Cp1383", "IBM AIX People's Republic of Chine (PRC)");
        ((Hashtable)defaultEncodings).put("Cp33722", "IBM-eucJP - Japanese (superset of 5050)");
        ((Hashtable)defaultEncodings).put("MS874", "Windows Thai");
        ((Hashtable)defaultEncodings).put("MacArabic", "Macintosh Arabic");
        ((Hashtable)defaultEncodings).put("MacCentralEurope", "Macintosh Latin-2");
        ((Hashtable)defaultEncodings).put("MacCroatian", "Macintosh Croatian");
        ((Hashtable)defaultEncodings).put("MacCyrillic", "Macintosh Cyrillic");
        ((Hashtable)defaultEncodings).put("MacDingbat", "Macintosh Dingbat");
        ((Hashtable)defaultEncodings).put("MacGreek", "Macintosh Greek");
        ((Hashtable)defaultEncodings).put("MacHebrew", "Macintosh Hebrew");
        ((Hashtable)defaultEncodings).put("MacIceland", "Macintosh Iceland");
        ((Hashtable)defaultEncodings).put("MacRoman", "Macintosh Roman");
        ((Hashtable)defaultEncodings).put("MacRomania", "Macintosh Romania");
        ((Hashtable)defaultEncodings).put("MacSymbol", "Macintosh Symbol");
        ((Hashtable)defaultEncodings).put("MacThai", "Macintosh Thai");
        ((Hashtable)defaultEncodings).put("MacTurkish", "Macintosh Turkish");
        ((Hashtable)defaultEncodings).put("MacUkraine", "Macintosh Ukraine");
    }

    public void addListDataListener(ListDataListener l) {
        if (this.listDataListeners == null) {
            this.listDataListeners = new ArrayList(5);
        }
        this.listDataListeners.add(l);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static EncodingComboBoxModel createDefaultModel() {
        EncodingComboBoxModel ecb;
        block7: {
            String availEncs;
            block6: {
                ecb = new EncodingComboBoxModel();
                availEncs = EncodingComboBoxModel.getAvailableEncodings();
                if (!availEncs.equalsIgnoreCase(AVAILABLE_ENCODINGS_ALL)) break block6;
                Properties encodings = EncodingComboBoxModel.getDefaultEncodings();
                Enumeration en = ((Hashtable)encodings).keys();
                while (en.hasMoreElements()) {
                    String enc = (String)en.nextElement();
                    ecb.addEncoding(enc, encodings.getProperty(enc, ENCODING_DEFAULT_DESCRIPTION));
                }
                break block7;
            }
            if (!availEncs.equals(AVAILABLE_ENCODINGS_FILE)) break block7;
            String encFile = EncodingComboBoxModel.getEncodingsDefinitionFile();
            InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)encFile, (Class)(class$org$jfree$report$modules$gui$base$components$EncodingComboBoxModel != null ? class$org$jfree$report$modules$gui$base$components$EncodingComboBoxModel : (class$org$jfree$report$modules$gui$base$components$EncodingComboBoxModel = EncodingComboBoxModel.class$("org.jfree.report.modules.gui.base.components.EncodingComboBoxModel"))));
            if (in == null) {
                Log.warn(new Log.SimpleMessage("The specified encodings definition file was not found: ", (Object)encFile));
            } else {
                try {
                    Properties defaultEncodings = EncodingComboBoxModel.getDefaultEncodings();
                    Properties encDef = new Properties();
                    BufferedInputStream bin = new BufferedInputStream(in);
                    encDef.load(bin);
                    bin.close();
                    Enumeration en = ((Hashtable)encDef).keys();
                    while (en.hasMoreElements()) {
                        String enc = (String)en.nextElement();
                        if (!encDef.getProperty(enc, "false").equalsIgnoreCase("true")) continue;
                        ecb.addEncoding(enc, defaultEncodings.getProperty(enc, ENCODING_DEFAULT_DESCRIPTION));
                    }
                }
                catch (IOException e) {
                    Log.warn(new Log.SimpleMessage("There was an error while reading the encodings definition file: ", (Object)encFile), e);
                }
            }
        }
        return ecb;
    }

    public void ensureEncodingAvailable(String encoding) {
        if (encoding == null) {
            throw new NullPointerException("Encoding must not be null");
        }
        String desc = EncodingComboBoxModel.getDefaultEncodings().getProperty(encoding, ENCODING_DEFAULT_DESCRIPTION);
        EncodingCarrier ec = new EncodingCarrier(encoding, desc);
        if (!this.encodings.contains(ec)) {
            this.encodings.add(ec);
            this.fireContentsChanged();
        }
    }

    protected void fireContentsChanged() {
        if (this.listDataListeners == null) {
            return;
        }
        ListDataEvent evt = new ListDataEvent(this, 0, 0, this.getSize());
        int i = 0;
        while (i < this.listDataListeners.size()) {
            ListDataListener l = (ListDataListener)this.listDataListeners.get(i);
            l.contentsChanged(evt);
            ++i;
        }
    }

    public static String getAvailableEncodings() {
        return ReportConfiguration.getGlobalConfig().getConfigProperty(AVAILABLE_ENCODINGS, AVAILABLE_ENCODINGS_ALL);
    }

    protected static Properties getDefaultEncodings() {
        if (defaultEncodings == null) {
            defaultEncodings = new Properties();
            EncodingComboBoxModel.addBasicEncodings();
            EncodingComboBoxModel.addExtendedEncodings();
        }
        return defaultEncodings;
    }

    public String getDescription(int index) {
        EncodingCarrier ec = (EncodingCarrier)this.encodings.get(index);
        return ec.getDescription();
    }

    public Object getElementAt(int index) {
        EncodingCarrier ec = (EncodingCarrier)this.encodings.get(index);
        return ec.getDisplayName();
    }

    public String getEncoding(int index) {
        EncodingCarrier ec = (EncodingCarrier)this.encodings.get(index);
        return ec.getName();
    }

    public static String getEncodingsDefinitionFile() {
        return ReportConfiguration.getGlobalConfig().getConfigProperty(ENCODINGS_DEFINITION_FILE, ENCODINGS_DEFINITION_FILE_DEFAULT);
    }

    public String getSelectedEncoding() {
        if (this.selectedIndex == -1) {
            return null;
        }
        EncodingCarrier ec = (EncodingCarrier)this.encodings.get(this.selectedIndex);
        return ec.getName();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public int getSize() {
        return this.encodings.size();
    }

    public int indexOf(String encoding) {
        return this.encodings.indexOf(new EncodingCarrier(encoding, null));
    }

    public void removeEncoding(String name) {
        if (((AbstractCollection)this.encodings).remove(name)) {
            this.fireContentsChanged();
        }
    }

    public void removeListDataListener(ListDataListener l) {
        if (this.listDataListeners == null) {
            return;
        }
        ((AbstractCollection)this.listDataListeners).remove(l);
    }

    public void setSelectedEncoding(String encoding) {
        int size = this.encodings.size();
        int i = 0;
        while (i < size) {
            EncodingCarrier carrier = (EncodingCarrier)this.encodings.get(i);
            if (encoding.equals(carrier.getName())) {
                this.selectedIndex = i;
                this.selectedObject = carrier.getDisplayName();
                return;
            }
            ++i;
        }
        if (size > 0) {
            this.selectedIndex = 0;
            this.selectedObject = this.getElementAt(0);
        }
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            this.selectedIndex = -1;
            this.selectedObject = null;
            return;
        }
        if (index < -1 || index >= this.getSize()) {
            throw new IllegalArgumentException("Index is invalid.");
        }
        this.selectedIndex = index;
        this.selectedObject = this.getElementAt(index);
    }

    public void setSelectedItem(Object anItem) {
        this.selectedObject = anItem;
        if (anItem instanceof String) {
            int size = this.getSize();
            int i = 0;
            while (i < size) {
                if (anItem.equals(this.getElementAt(i))) {
                    this.selectedIndex = i;
                    return;
                }
                ++i;
            }
        }
        this.selectedIndex = -1;
    }

    public void sort() {
        Object selectedObject = this.getSelectedItem();
        Collections.sort(this.encodings, new EncodingCarrierComparator());
        this.setSelectedItem(selectedObject);
        this.fireContentsChanged();
    }

    private static class EncodingCarrierComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            EncodingCarrier e1 = (EncodingCarrier)o1;
            EncodingCarrier e2 = (EncodingCarrier)o2;
            return e1.getName().toLowerCase().compareTo(e2.getName().toLowerCase());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return this.getClass().equals(o.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class EncodingCarrier {
        private String name;
        private String description;
        private String displayName;

        public EncodingCarrier(String name, String description) {
            if (name == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.description = description;
            StringBuffer dName = new StringBuffer();
            dName.append(name);
            dName.append(" (");
            dName.append(description);
            dName.append(")");
            this.displayName = dName.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EncodingCarrier)) {
                return false;
            }
            EncodingCarrier carrier = (EncodingCarrier)o;
            return this.name.equalsIgnoreCase(carrier.name);
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

