/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jfree.report.JFreeReport;
import org.jfree.report.PageDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.event.RepaginationListener;
import org.jfree.report.event.RepaginationState;
import org.jfree.report.modules.output.pageable.base.OutputTargetException;
import org.jfree.report.modules.output.pageable.base.PageProcess;
import org.jfree.report.modules.output.pageable.base.PageableReportProcessor;
import org.jfree.report.modules.output.pageable.graphics.G2OutputTarget;
import org.jfree.report.util.Log;

public class ReportPane
extends JComponent
implements Printable,
Pageable,
RepaginationListener {
    public static final String PAGINATED_PROPERTY = "Paginated";
    public static final String NUMBER_OF_PAGES_PROPERTY = "NumberOfPages";
    public static final String PAGENUMBER_PROPERTY = "PageNumber";
    public static final String ZOOMFACTOR_PROPERTY = "ZoomFactor";
    public static final String ERROR_PROPERTY = "Error";
    public static final String BORDER_PROPERTY = "BorderPainted";
    public static final String PRINTING_PROPERTY = "printing";
    public static final String PAGINATING_PROPERTY = "paginating";
    private static final float PAPERBORDER_PIXEL = 6.0f;
    private BufferedImage graphCache;
    private int pageNumber;
    private float zoomFactor;
    private int pageCount;
    private boolean borderPainted;
    private Exception error;
    private JFreeReport report;
    protected static final int PAGINATE_IDLE = 0;
    protected static final int PAGINATE_PAGINATING = 1;
    protected static final int PAGINATE_PRINTING = 2;
    private final PaginateLock paginateLock = new PaginateLock();
    private PageableReportProcessor processor;
    private PageProcess pageProcess;
    private ArrayList repaginationListeners;
    private transient Object[] repaginationListenersCache;

    public ReportPane(JFreeReport report) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException("Report is null.");
        }
        this.repaginationListeners = new ArrayList();
        this.report = report;
        this.setDoubleBuffered(true);
        this.processor = new PageableReportProcessor(report);
        this.processor.addRepaginationListener(this);
        this.borderPainted = false;
        this.pageNumber = 1;
        this.setZoomFactor(1.0f);
    }

    public void addRepaginationListener(RepaginationListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must not be null.");
        }
        this.repaginationListenersCache = null;
        this.repaginationListeners.add(listener);
    }

    public void clearError() {
        this.setError(null);
    }

    public void dispose() {
        this.setPaginated(false);
        this.graphCache = null;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireSynchronousPropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeRunnable runnable = new PropertyChangeRunnable(propertyName, oldValue, newValue);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Log.error("Unable to propagate PropertyChange.", e);
            }
        }
    }

    protected PageFormat getCurrentPageFormat() {
        PageDefinition pdef = this.getReport().getPageDefinition();
        int pageNumber = this.getPageNumber() == 0 ? 0 : (this.getPageNumber() - 1) % pdef.getPageCount();
        return this.getPageFormat(pageNumber);
    }

    public Exception getError() {
        return this.error;
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public int getNumberOfPages() {
        block3: {
            if (this.isPaginating()) {
                return this.pageCount;
            }
            if (this.isPaginated()) break block3;
            try {
                this.repaginate();
            }
            catch (Exception exception) {
                this.pageCount = 0;
            }
        }
        return this.pageCount;
    }

    public PageFormat getPageFormat(int page) {
        JFreeReport report = this.getReport();
        PageDefinition pdef = report.getPageDefinition();
        return pdef.getPageFormat(page % pdef.getPageCount());
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    protected PageProcess getPageProcess() {
        return this.pageProcess;
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Printable getPrintable(int page) {
        return this;
    }

    protected PageableReportProcessor getProcessor() {
        return this.processor;
    }

    public JFreeReport getReport() {
        return this.report;
    }

    public Object getReportLock() {
        return this.paginateLock;
    }

    public float getZoomFactory() {
        return this.zoomFactor;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public boolean isHandleInterruptedState() {
        return this.processor.isHandleInterruptedState();
    }

    public boolean isOpaque() {
        return false;
    }

    protected boolean isPaginated() {
        return this.pageProcess != null;
    }

    public boolean isPaginating() {
        return this.paginateLock.isPaginating();
    }

    public boolean isPrinting() {
        return this.paginateLock.isPrinting();
    }

    public void paintComponent(Graphics g) {
        if (this.paginateLock.isPaginating()) {
            return;
        }
        try {
            Graphics2D g2org = (Graphics2D)g;
            if (this.graphCache == null) {
                Graphics2D g2;
                PageFormat pageFormat = this.getCurrentPageFormat();
                Dimension size = this.getSize();
                float outerX = 0.0f;
                float outerY = 0.0f;
                float realouterW = (float)size.getWidth() - 1.0f;
                float realouterH = (float)size.getHeight() - 1.0f;
                float outerW = (float)pageFormat.getWidth();
                float outerH = (float)pageFormat.getHeight();
                float innerX = (float)pageFormat.getImageableX();
                float innerY = (float)pageFormat.getImageableY();
                float innerW = (float)pageFormat.getImageableWidth();
                float innerH = (float)pageFormat.getImageableHeight();
                if (realouterW > 1500.0f || realouterH > 1500.0f) {
                    this.graphCache = null;
                    g2 = g2org;
                } else {
                    this.graphCache = g2org.getDeviceConfiguration().createCompatibleImage((int)realouterW, (int)realouterH);
                    g2 = this.graphCache.createGraphics();
                }
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                Rectangle2D.Float pageArea = new Rectangle2D.Float(0.0f, 0.0f, realouterW, realouterH);
                g2.setPaint(this.getBackground());
                g2.fill(pageArea);
                g2.transform(AffineTransform.getScaleInstance(this.zoomFactor, this.zoomFactor));
                pageArea = new Rectangle2D.Float(0.0f, 0.0f, outerW - 2.0f, outerH - 2.0f);
                g2.setPaint(Color.white);
                g2.fill(pageArea);
                this.performGeneratePage(g2);
                Rectangle2D.Float printingArea = new Rectangle2D.Float(innerX, innerY, innerW, innerH);
                Rectangle2D.Float southborder = new Rectangle2D.Float(4.0f, 0.0f + outerH - 2.0f, outerW, 6.0f);
                g2.setPaint(UIManager.getColor("controlShadow"));
                g2.fill(southborder);
                Rectangle2D.Float eastborder = new Rectangle2D.Float(outerW - 2.0f, 4.0f, 6.0f, outerH);
                g2.fill(eastborder);
                Rectangle2D.Float transPageArea = (double)this.zoomFactor > 1.49 ? new Rectangle2D.Float(0.0f, 0.0f, outerW - 1.0f, outerH - 1.0f) : new Rectangle2D.Float(0.0f, 0.0f, outerW - 2.0f, outerH - 2.0f);
                g2.setPaint(Color.black);
                g2.draw(transPageArea);
                if (this.isBorderPainted()) {
                    g2.setPaint(Color.gray);
                    g2.draw(printingArea);
                }
                if (this.graphCache != null) {
                    g2.dispose();
                }
            }
            if (this.graphCache != null) {
                g2org.drawImage(this.graphCache, new AffineTransformOp(g2org.getDeviceConfiguration().getDefaultTransform(), g2org.getRenderingHints()), 0, 0);
            } else {
                super.paintComponent(g);
            }
        }
        catch (Exception e) {
            this.setError(e);
            super.paintComponent(g);
        }
    }

    private void performGeneratePage(Graphics2D g2) throws OutputTargetException {
        try {
            PaginateLock paginateLock = this.paginateLock;
            synchronized (paginateLock) {
                if (this.isPrinting()) {
                    Object var3_4 = null;
                    return;
                }
                this.repaginate();
            }
        }
        catch (ReportProcessingException rpe) {
            Log.error("Repaginate failed: ", (Exception)((Object)rpe));
            this.setError((Exception)((Object)rpe));
        }
        PaginateLock rpe = this.paginateLock;
        synchronized (rpe) {
            G2OutputTarget target = new G2OutputTarget(g2);
            target.open();
            this.getProcessor().setOutputTarget(target);
            int pageNumber = this.getPageNumber();
            if (pageNumber > 0) {
                try {
                    this.getProcessor().processPage(this.getPageProcess(), pageNumber - 1, true);
                }
                catch (ReportProcessingException rpe2) {
                    Log.error("Repaginate failed: ", (Exception)((Object)rpe2));
                    this.setError((Exception)((Object)rpe2));
                }
            } else {
                Log.error("PageNumber is invalid after repaginating: " + pageNumber);
            }
            target.close();
            this.getProcessor().setOutputTarget(null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeRepaginationListener(RepaginationListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must not be null.");
        }
        this.repaginationListenersCache = null;
        ((AbstractCollection)this.repaginationListeners).remove(listener);
    }

    public void repaginate() throws ReportProcessingException {
        PaginateLock pageCount22;
        PaginateLock paginateLock = this.paginateLock;
        synchronized (paginateLock) {
            if (this.isPaginated()) {
                Object var2_3 = null;
                return;
            }
            if (this.isPaginating() || this.isPrinting()) {
                throw new IllegalStateException("Already paginating or printing.");
            }
            this.setPaginated(false);
            this.setPaginating(true);
        }
        boolean addedOutputTarget = false;
        if (this.getProcessor().getOutputTarget() == null) {
            try {
                G2OutputTarget target = new G2OutputTarget(G2OutputTarget.createEmptyGraphics());
                target.open();
                this.getProcessor().setOutputTarget(target);
            }
            catch (OutputTargetException oe) {
                Log.error("Unable to repaginate: Error", (Exception)((Object)oe));
            }
            addedOutputTarget = true;
        }
        try {
            this.processor.repaginate();
            int pageCount22 = this.processor.getPageCount();
            this.setCurrentPageCount(pageCount22);
            if (pageCount22 > 0) {
                this.setPageNumber(1);
            } else {
                this.setPageNumber(0);
            }
            PaginateLock paginateLock2 = this.paginateLock;
            synchronized (paginateLock2) {
                this.setPaginated(true);
            }
            Object var3_11 = null;
            if (addedOutputTarget) {
                this.getProcessor().setOutputTarget(null);
            }
            pageCount22 = this.paginateLock;
        }
        catch (Throwable throwable) {
            Object var3_12 = null;
            if (addedOutputTarget) {
                this.getProcessor().setOutputTarget(null);
            }
            PaginateLock pageCount22 = this.paginateLock;
            synchronized (pageCount22) {
                this.setPaginating(false);
            }
            throw throwable;
        }
        synchronized (pageCount22) {
            this.setPaginating(false);
        }
    }

    public void repaginationUpdate(RepaginationState state) {
        if (this.repaginationListenersCache == null) {
            this.repaginationListenersCache = this.repaginationListeners.toArray();
        }
        int i = 0;
        while (i < this.repaginationListenersCache.length) {
            RepaginationListener l = (RepaginationListener)this.repaginationListenersCache[i];
            l.repaginationUpdate(state);
            ++i;
        }
    }

    public void setBorderPainted(boolean b) {
        boolean oldval = this.isBorderPainted();
        this.borderPainted = b;
        this.revalidate();
        this.firePropertyChange(BORDER_PROPERTY, oldval, b);
    }

    private void setCurrentPageCount(int pc) {
        int oldpc = this.pageCount;
        this.pageCount = pc;
        this.fireSynchronousPropertyChange(NUMBER_OF_PAGES_PROPERTY, new Integer(oldpc), new Integer(pc));
    }

    public void setError(Exception error) {
        Exception oldError = this.error;
        this.error = error;
        this.firePropertyChange(ERROR_PROPERTY, oldError, error);
    }

    public void setHandleInterruptedState(boolean handleInterruptedState) {
        this.processor.setHandleInterruptedState(handleInterruptedState);
    }

    public void setPageNumber(int page) {
        if (page > this.getNumberOfPages()) {
            return;
        }
        if (page < 1) {
            page = 0;
        }
        if (page <= this.getNumberOfPages()) {
            int oldpage = this.pageNumber;
            this.pageNumber = page;
            this.graphCache = null;
            this.repaint();
            this.fireSynchronousPropertyChange(PAGENUMBER_PROPERTY, new Integer(oldpage), new Integer(page));
        }
    }

    protected void setPaginated(boolean paginated) {
        if (paginated == this.isPaginated()) {
            return;
        }
        boolean oldPaginated = this.isPaginated();
        if (paginated) {
            this.pageProcess = this.processor.createPageProcess();
        } else {
            this.pageProcess = null;
            this.processor.resetPagination();
        }
        this.firePropertyChange(PAGINATED_PROPERTY, oldPaginated, paginated);
    }

    protected void setPaginating(boolean paginating) {
        boolean oldPaginating = this.isPaginating();
        PaginateLock paginateLock = this.paginateLock;
        synchronized (paginateLock) {
            if (paginating) {
                this.paginateLock.setPaginateState(1);
            } else {
                this.paginateLock.setPaginateState(0);
            }
        }
        this.firePropertyChange(PAGINATING_PROPERTY, oldPaginating, paginating);
    }

    public void setPrinting(boolean printing) {
        boolean oldPrinting = this.isPrinting();
        if (this.isPaginating()) {
            throw new IllegalStateException("Is currently paginating.");
        }
        PaginateLock paginateLock = this.paginateLock;
        synchronized (paginateLock) {
            if (printing) {
                this.paginateLock.setPaginateState(2);
            } else {
                this.paginateLock.setPaginateState(0);
            }
        }
        this.firePropertyChange(PRINTING_PROPERTY, oldPrinting, printing);
    }

    public void setZoomFactor(float factor) {
        double oldzoom = this.zoomFactor;
        this.zoomFactor = factor;
        this.graphCache = null;
        PageFormat pageFormat = this.getCurrentPageFormat();
        int w = (int)((pageFormat.getWidth() + 6.0) * (double)this.zoomFactor);
        int h = (int)((pageFormat.getHeight() + 6.0) * (double)this.zoomFactor);
        super.setSize(w, h);
        this.firePropertyChange(ZOOMFACTOR_PROPERTY, new Double(oldzoom), new Double(factor));
    }

    private class PropertyChangeRunnable
    implements Runnable {
        private String property;
        private Object oldValue;
        private Object newValue;

        public PropertyChangeRunnable(String property, Object oldValue, Object newValue) {
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void run() {
            ReportPane.this.firePropertyChange(this.property, this.oldValue, this.newValue);
        }
    }

    private static class PaginateLock {
        private int paginateState = 0;

        public synchronized boolean isIdle() {
            return this.paginateState == 0;
        }

        public synchronized boolean isPaginating() {
            return this.paginateState == 1;
        }

        public synchronized boolean isPrinting() {
            return this.paginateState == 2;
        }

        public synchronized void setPaginateState(int p) {
            this.paginateState = p;
        }
    }
}

