/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.report.modules.gui.base.ExportPlugin;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.WorkerPool;
import org.jfree.util.Log;

public final class ExportPluginFactory {
    private static ExportPluginFactory factory;
    private final ArrayList exportPlugins = new ArrayList();
    static /* synthetic */ Class class$org$jfree$report$modules$gui$base$ExportPlugin;

    private ExportPluginFactory() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ArrayList createExportPlugIns(PreviewProxy proxy, ReportConfiguration config, WorkerPool worker) {
        Object[] def = this.exportPlugins.toArray(new PluginDefinition[this.exportPlugins.size()]);
        Arrays.sort(def);
        ArrayList<ExportPlugin> retval = new ArrayList<ExportPlugin>();
        int i = 0;
        while (i < def.length) {
            Object definition = def[i];
            if (this.isPluginEnabled(config, ((PluginDefinition)definition).getEnableKey())) {
                ExportPlugin ep = this.createPlugIn(proxy, ((PluginDefinition)definition).getPluginClass());
                if (ep != null) {
                    ep.defineWorkerPool(worker);
                    retval.add(ep);
                } else {
                    Log.warn("Cannot create plugin: " + ((PluginDefinition)definition).getPluginClass());
                }
            } else {
                Log.info(new Log.SimpleMessage("Plugin ", (Object)((PluginDefinition)definition).getPluginClass(), (Object)",", (Object)((PluginDefinition)definition).getEnableKey(), (Object)" is not enabled."));
            }
            ++i;
        }
        return retval;
    }

    protected ExportPlugin createPlugIn(PreviewProxy proxy, Class plugin) {
        if (proxy == null) {
            throw new NullPointerException("PreviewProxy must not be null.");
        }
        try {
            ExportPlugin ep = (ExportPlugin)plugin.newInstance();
            ep.init(proxy);
            return ep;
        }
        catch (Exception e) {
            Log.warn("Unable to create the export plugin: " + plugin.getName(), e);
            return null;
        }
    }

    public static ExportPluginFactory getInstance() {
        if (factory == null) {
            factory = new ExportPluginFactory();
        }
        return factory;
    }

    protected boolean isPluginEnabled(ReportConfiguration config, String pluginKey) {
        return config.getConfigProperty(pluginKey, "false").equals("true");
    }

    public void registerPlugin(Class plugin, String preference, String enableKey) {
        if ((class$org$jfree$report$modules$gui$base$ExportPlugin != null ? class$org$jfree$report$modules$gui$base$ExportPlugin : (class$org$jfree$report$modules$gui$base$ExportPlugin = ExportPluginFactory.class$("org.jfree.report.modules.gui.base.ExportPlugin"))).isAssignableFrom(plugin)) {
            PluginDefinition def = new PluginDefinition(plugin, preference, enableKey);
            if (!this.exportPlugins.contains(def)) {
                this.exportPlugins.add(def);
            }
            Log.debug("Registered Plugin " + plugin);
        }
    }

    private static class PluginDefinition
    implements Comparable {
        private Class pluginClass;
        private String preference;
        private String enableKey;

        public PluginDefinition(Class pluginClass, String preference, String enableKey) {
            if (pluginClass == null) {
                throw new NullPointerException("PluginClass is null.");
            }
            if (enableKey == null) {
                throw new NullPointerException("EnableKey is null.");
            }
            if (preference == null) {
                throw new NullPointerException("Preference is null.");
            }
            this.pluginClass = pluginClass;
            this.enableKey = enableKey;
            this.preference = preference;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            PluginDefinition def = (PluginDefinition)o;
            return this.getPreference().compareTo(def.getPreference());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PluginDefinition)) {
                return false;
            }
            PluginDefinition pluginDefinition = (PluginDefinition)o;
            return this.pluginClass.equals(pluginDefinition.pluginClass);
        }

        public String getEnableKey() {
            return this.enableKey;
        }

        public Class getPluginClass() {
            return this.pluginClass;
        }

        public String getPreference() {
            return this.preference;
        }

        public int hashCode() {
            return this.pluginClass.hashCode();
        }
    }
}

