/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.layout;

import java.util.HashMap;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.Log;
import org.jfree.report.util.geom.StrictDimension;

public class LayoutManagerCache {
    private static int putCount;
    private static int getCount;
    private final HashMap elementCache = new HashMap();

    public void flush() {
        this.elementCache.clear();
    }

    public StrictDimension getMinSize(Object e) {
        ElementCacheCarrier ec = (ElementCacheCarrier)this.elementCache.get(e);
        if (ec == null) {
            return null;
        }
        StrictDimension dim = ec.getMinSize();
        if (dim != null) {
            ++getCount;
            return dim.getUnlockedInstance();
        }
        return null;
    }

    public StrictDimension getPrefSize(Object e) {
        ElementCacheCarrier ec = (ElementCacheCarrier)this.elementCache.get(e);
        if (ec == null) {
            return null;
        }
        StrictDimension dim = ec.getPrefSize();
        if (dim != null) {
            ++getCount;
            return dim.getUnlockedInstance();
        }
        return null;
    }

    public boolean isCachable(Element e) {
        if (!e.getStyle().getBooleanStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE)) {
            return false;
        }
        if (e.getStyle().getBooleanStyleProperty(ElementStyleSheet.DYNAMIC_HEIGHT)) {
            e.getStyle().setBooleanStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE, false);
            return false;
        }
        if (e instanceof Band) {
            Element[] elements = ((Band)e).getElementArray();
            int i = 0;
            while (i < elements.length) {
                if (!this.isCachable(elements[i])) {
                    e.getStyle().setBooleanStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE, false);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static void printResults() {
        Log.debug("CacheResults: " + getCount + ":" + putCount + " Ratio: " + (double)getCount / (double)putCount);
    }

    public void setMinSize(Element element, StrictDimension d) {
        if (element == null) {
            throw new NullPointerException("Element is null");
        }
        ++putCount;
        ElementCacheCarrier ec = (ElementCacheCarrier)this.elementCache.get(element.getObjectID());
        if (ec == null) {
            ec = new ElementCacheCarrier();
            ec.setMinSize(d.getLockedInstance());
            this.elementCache.put(element.getObjectID(), ec);
        } else {
            ec.setMinSize(d.getLockedInstance());
        }
    }

    public void setPrefSize(Element element, StrictDimension d) {
        if (element == null) {
            throw new IllegalArgumentException("LayoutCacheKey: Element is null");
        }
        ++putCount;
        ElementCacheCarrier ec = (ElementCacheCarrier)this.elementCache.get(element.getObjectID());
        if (ec == null) {
            ec = new ElementCacheCarrier();
            ec.setPrefSize(d.getLockedInstance());
            this.elementCache.put(element.getObjectID(), ec);
        } else {
            ec.setPrefSize(d.getLockedInstance());
        }
    }

    private static class ElementCacheCarrier {
        private StrictDimension minSize;
        private StrictDimension prefSize;

        public StrictDimension getMinSize() {
            return this.minSize;
        }

        public StrictDimension getPrefSize() {
            return this.prefSize;
        }

        public void setMinSize(StrictDimension dimension2D) {
            this.minSize = dimension2D;
        }

        public void setPrefSize(StrictDimension dimension2D) {
            this.prefSize = dimension2D;
        }
    }
}

