/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.layout;

import org.jfree.report.content.AnchorContentFactoryModule;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.DefaultContentFactory;
import org.jfree.report.content.DrawableContentFactoryModule;
import org.jfree.report.content.ImageContentFactoryModule;
import org.jfree.report.content.ShapeContentFactoryModule;
import org.jfree.report.content.TextContentFactoryModule;
import org.jfree.report.layout.DefaultSizeCalculator;
import org.jfree.report.layout.LayoutManagerCache;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.layout.SizeCalculator;
import org.jfree.report.layout.SizeCalculatorException;
import org.jfree.report.style.FontDefinition;

public class DefaultLayoutSupport
implements LayoutSupport {
    private ContentFactory contentFactory;
    private LayoutManagerCache cache;

    public DefaultLayoutSupport() {
        DefaultContentFactory contentFactory = new DefaultContentFactory();
        contentFactory.addModule(new TextContentFactoryModule());
        contentFactory.addModule(new ImageContentFactoryModule());
        contentFactory.addModule(new ShapeContentFactoryModule());
        contentFactory.addModule(new DrawableContentFactoryModule());
        contentFactory.addModule(new AnchorContentFactoryModule());
        this.contentFactory = contentFactory;
        this.cache = new LayoutManagerCache();
    }

    public DefaultLayoutSupport(ContentFactory cf) {
        if (cf == null) {
            throw new NullPointerException();
        }
        this.contentFactory = cf;
        this.cache = new LayoutManagerCache();
    }

    public SizeCalculator createTextSizeCalculator(FontDefinition font) throws SizeCalculatorException {
        return DefaultSizeCalculator.getDefaultSizeCalculator(font);
    }

    public LayoutManagerCache getCache() {
        return this.cache;
    }

    public ContentFactory getContentFactory() {
        return this.contentFactory;
    }

    public float getHorizontalAlignmentBorder() {
        return 0.0f;
    }

    public long getInternalHorizontalAlignmentBorder() {
        return 0L;
    }

    public long getInternalVerticalAlignmentBorder() {
        return 0L;
    }

    public float getVerticalAlignmentBorder() {
        return 0.0f;
    }
}

