/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionUtilities;
import org.jfree.report.util.Log;

public class TotalGroupSumQuotientFunction
extends AbstractFunction
implements Serializable {
    private transient GroupSum groupDividend = new GroupSum();
    private transient GroupSum groupDivisor = new GroupSum();
    private transient ArrayList dividendResults = new ArrayList();
    private transient ArrayList divisorResults = new ArrayList();
    private transient int currentIndex;
    private String group;
    private String dividend;
    private String divisor;

    public String getDividend() {
        return this.dividend;
    }

    public String getDivisor() {
        return this.divisor;
    }

    public String getGroup() {
        return this.group;
    }

    public Expression getInstance() {
        TotalGroupSumQuotientFunction function = (TotalGroupSumQuotientFunction)super.getInstance();
        function.groupDividend = new GroupSum();
        function.groupDivisor = new GroupSum();
        function.dividendResults = new ArrayList();
        function.divisorResults = new ArrayList();
        return function;
    }

    public Object getValue() {
        BigDecimal dividend = this.groupDividend.getResult();
        BigDecimal divisor = this.groupDivisor.getResult();
        if (divisor.intValue() == 0) {
            return new Double(Double.NaN);
        }
        return new Double(dividend.doubleValue() / divisor.doubleValue());
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.groupDividend = new GroupSum();
            this.dividendResults.add(this.groupDividend);
            this.groupDivisor = new GroupSum();
            this.divisorResults.add(this.groupDivisor);
        } else if (!event.getState().isPrepareRun()) {
            ++this.currentIndex;
            this.groupDividend = (GroupSum)this.dividendResults.get(this.currentIndex);
            this.groupDivisor = (GroupSum)this.divisorResults.get(this.currentIndex);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        block6: {
            Number n;
            if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
                return;
            }
            Object fieldValue = event.getDataRow().get(this.getDividend());
            if (fieldValue != null) {
                try {
                    n = (Number)fieldValue;
                    this.groupDividend.add(n);
                }
                catch (Exception exception) {
                    Log.error("ItemSumFunction.advanceItems(): problem adding dividend.");
                }
            }
            if ((fieldValue = event.getDataRow().get(this.getDivisor())) == null) break block6;
            try {
                n = (Number)fieldValue;
                this.groupDivisor.add(n);
            }
            catch (Exception exception) {
                Log.error("ItemSumFunction.advanceItems(): problem adding divisor.");
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.groupDividend = new GroupSum();
        this.groupDivisor = new GroupSum();
        this.dividendResults = new ArrayList();
        this.divisorResults = new ArrayList();
    }

    public void reportInitialized(ReportEvent event) {
        this.currentIndex = -1;
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.dividendResults.clear();
            this.divisorResults.clear();
        }
    }

    public void setDividend(String dividend) {
        this.dividend = dividend;
    }

    public void setDivisor(String divisor) {
        this.divisor = divisor;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    private static class GroupSum
    implements Serializable {
        private BigDecimal result = new BigDecimal(0.0);

        public void add(Number n) {
            this.result = this.result.add(new BigDecimal(n.toString()));
        }

        public BigDecimal getResult() {
            return this.result;
        }
    }
}

