/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.FunctionUtilities;

public class TotalCalculationFunction
extends AbstractFunction
implements Serializable {
    private transient ArrayList storedResults = new ArrayList();
    private transient int currentIndex;
    private transient Object currentObject;
    private String field;
    private String group;

    public String getField() {
        return this.field;
    }

    public String getGroup() {
        return this.group;
    }

    public Object getValue() {
        return this.currentObject;
    }

    public void groupFinished(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.storedResults.add(this.currentObject);
        }
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.currentObject = null;
        } else if (!event.getState().isPrepareRun()) {
            ++this.currentIndex;
            this.currentObject = this.storedResults.get(this.currentIndex);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storedResults = new ArrayList();
    }

    public void reportFinished(ReportEvent event) {
        if (this.getGroup() == null) {
            this.storedResults.add(this.currentObject);
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.currentIndex = -1;
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.storedResults.clear();
        } else if (this.getGroup() == null) {
            this.storedResults.get(0);
        }
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

