/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.Group;
import org.jfree.report.GroupFooter;
import org.jfree.report.event.LayoutEvent;
import org.jfree.report.event.LayoutListener;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.states.ReportState;

public class PageFunction
extends AbstractFunction
implements Serializable,
PageEventListener,
LayoutListener {
    private transient int page;
    private transient boolean isGroupStarted;
    private transient boolean ignoreNextGroup;
    private transient boolean waitForFooterPrinted;
    private String group;
    private int startPage = 1;
    private boolean ignorePageCancelEvents;

    public PageFunction() {
    }

    public PageFunction(String name) {
        this.setName(name);
    }

    public String getGroup() {
        return this.group;
    }

    protected int getPage() {
        return this.page;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public Object getValue() {
        return new Integer(this.getPage());
    }

    public void groupFinished(ReportEvent event) {
        if (this.getGroup() == null) {
            return;
        }
        ReportState state = event.getState();
        Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.setWaitForFooterPrinted(true);
        }
    }

    public void groupStarted(ReportEvent event) {
        if (this.getGroup() == null) {
            return;
        }
        if (this.isGroupStarted()) {
            return;
        }
        ReportState state = event.getState();
        Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            if (!this.isIgnoreNextGroup()) {
                this.setGroupStarted(true);
            }
            this.setIgnoreNextGroup(false);
        }
    }

    protected boolean isGroupStarted() {
        return this.isGroupStarted;
    }

    protected boolean isIgnoreNextGroup() {
        return this.ignoreNextGroup;
    }

    public boolean isIgnorePageCancelEvents() {
        return this.ignorePageCancelEvents;
    }

    protected boolean isWaitForFooterPrinted() {
        return this.waitForFooterPrinted;
    }

    public void layoutComplete(LayoutEvent event) {
    }

    public void outputComplete(LayoutEvent event) {
        if (!this.isWaitForFooterPrinted()) {
            return;
        }
        if (event.getLayoutedBand() instanceof GroupFooter) {
            this.setGroupStarted(true);
            this.setIgnoreNextGroup(true);
            this.setWaitForFooterPrinted(false);
        }
    }

    public void pageCanceled(ReportEvent event) {
        if (this.isIgnorePageCancelEvents()) {
            return;
        }
        this.setPage(this.getPage() - 1);
    }

    public void pageFinished(ReportEvent event) {
    }

    public void pageRolledBack(ReportEvent event) {
    }

    public void pageStarted(ReportEvent event) {
        if (this.isGroupStarted()) {
            this.setPage(this.getStartPage());
            this.setGroupStarted(false);
        } else {
            this.setPage(this.getPage() + 1);
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.setPage(this.getStartPage() - 1);
        this.setIgnoreNextGroup(true);
        this.setWaitForFooterPrinted(false);
    }

    public void setGroup(String group) {
        this.group = group;
    }

    protected void setGroupStarted(boolean groupStarted) {
        this.isGroupStarted = groupStarted;
    }

    protected void setIgnoreNextGroup(boolean ignoreNextGroup) {
        this.ignoreNextGroup = ignoreNextGroup;
    }

    public void setIgnorePageCancelEvents(boolean ignorePageCancelEvents) {
        this.ignorePageCancelEvents = ignorePageCancelEvents;
    }

    protected void setPage(int page) {
        this.page = page;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    protected void setWaitForFooterPrinted(boolean waitForFooterPrinted) {
        this.waitForFooterPrinted = waitForFooterPrinted;
    }
}

