/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.Group;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.util.Log;

public class ItemMinFunction
extends AbstractFunction
implements Serializable {
    private transient Comparable min = null;
    private String group;
    private String field;

    public ItemMinFunction() {
    }

    public ItemMinFunction(String name) {
        this();
        this.setName(name);
    }

    public String getField() {
        return this.field;
    }

    public String getGroup() {
        return this.group;
    }

    public Expression getInstance() {
        ItemMinFunction function = (ItemMinFunction)super.getInstance();
        function.min = null;
        return function;
    }

    public Object getValue() {
        return this.min;
    }

    public void groupStarted(ReportEvent event) {
        String mygroup = this.getGroup();
        if (mygroup == null) {
            return;
        }
        Group group = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.min = null;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Comparable)) {
            return;
        }
        try {
            Comparable compare = (Comparable)fieldValue;
            if (this.min == null) {
                this.min = compare;
            } else if (this.min.compareTo(compare) > 0) {
                this.min = compare;
            }
        }
        catch (Exception exception) {
            Log.error("ItemMinFunction.advanceItems(): problem adding number.");
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.min = null;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setGroup(String name) {
        this.group = name;
    }
}

