/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.Group;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.util.Log;

public class ItemMaxFunction
extends AbstractFunction
implements Serializable {
    private String group;
    private String field;
    private transient Comparable max = null;

    public ItemMaxFunction() {
    }

    public ItemMaxFunction(String name) {
        this();
        this.setName(name);
    }

    public String getField() {
        return this.field;
    }

    public String getGroup() {
        return this.group;
    }

    public Expression getInstance() {
        ItemMaxFunction function = (ItemMaxFunction)super.getInstance();
        function.max = null;
        return function;
    }

    public Object getValue() {
        return this.max;
    }

    public void groupStarted(ReportEvent event) {
        String mygroup = this.getGroup();
        if (mygroup == null) {
            return;
        }
        Group group = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.max = null;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Comparable)) {
            return;
        }
        try {
            Comparable compare = (Comparable)fieldValue;
            if (this.max == null) {
                this.max = compare;
            } else if (this.max.compareTo(compare) < 0) {
                this.max = compare;
            }
        }
        catch (Exception exception) {
            Log.error("ItemMaxFunction.advanceItems(): problem comparing number.");
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.max = null;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setGroup(String name) {
        this.group = name;
    }
}

