/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.Element;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.util.ObjectUtilities;

public class ItemHideFunction
extends AbstractFunction
implements Serializable,
PageEventListener {
    private transient Object lastObject;
    private transient boolean visible;
    private transient boolean firstInGroup;
    private String element;
    private String field;

    public ItemHideFunction() {
    }

    public ItemHideFunction(String name) {
        this();
        this.setName(name);
    }

    public String getElement() {
        return this.element;
    }

    public String getField() {
        return this.field;
    }

    public Expression getInstance() {
        ItemHideFunction ih = (ItemHideFunction)super.getInstance();
        ih.lastObject = null;
        return ih;
    }

    public Object getValue() {
        if (this.visible) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        if (this.firstInGroup) {
            this.visible = true;
            this.firstInGroup = false;
        } else {
            this.visible = !ObjectUtilities.equal((Object)this.lastObject, (Object)fieldValue);
        }
        this.lastObject = fieldValue;
        Element e = event.getReport().getItemBand().getElement(this.getElement());
        if (e != null) {
            e.setVisible(this.visible);
        }
    }

    public void itemsStarted(ReportEvent event) {
        this.lastObject = null;
        this.firstInGroup = true;
    }

    public void pageCanceled(ReportEvent event) {
    }

    public void pageFinished(ReportEvent event) {
    }

    public void pageRolledBack(ReportEvent event) {
    }

    public void pageStarted(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        this.visible = true;
        this.firstInGroup = true;
        this.lastObject = fieldValue;
        Element e = event.getReport().getItemBand().getElement(this.getElement());
        if (e != null) {
            e.setVisible(this.visible);
        }
    }

    public void setElement(String name) {
        this.element = name;
    }

    public void setField(String field) {
        this.field = field;
    }
}

