/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jfree.report.Group;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.util.Log;

public class ItemAvgFunction
extends AbstractFunction
implements Serializable {
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private transient BigDecimal sum = ZERO;
    private transient BigDecimal itemCount = ZERO;
    private String group;
    private String field;

    public ItemAvgFunction() {
    }

    public ItemAvgFunction(String name) {
        this();
        this.setName(name);
    }

    public String getField() {
        return this.field;
    }

    public String getGroup() {
        return this.group;
    }

    public Expression getInstance() {
        ItemAvgFunction function = (ItemAvgFunction)super.getInstance();
        function.sum = ZERO;
        function.itemCount = ZERO;
        return function;
    }

    public Object getValue() {
        if (this.itemCount.longValue() == 0L) {
            return null;
        }
        return this.sum.divide(this.itemCount, 5);
    }

    public void groupStarted(ReportEvent event) {
        String mygroup = this.getGroup();
        if (mygroup == null) {
            return;
        }
        Group group = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.sum = ZERO;
            this.itemCount = ZERO;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        Number n = (Number)fieldValue;
        try {
            this.sum = this.sum.add(new BigDecimal(n.doubleValue()));
            this.itemCount = this.itemCount.add(ONE);
        }
        catch (Exception exception) {
            Log.error("ItemAvgFunction.advanceItems(): problem adding number.");
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.sum = ZERO;
        this.itemCount = ZERO;
    }

    public void setField(String field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this.field = field;
    }

    public void setGroup(String name) {
        this.group = name;
    }
}

