/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionInitializeException;

public class ExpressionCollection
implements Cloneable,
Serializable {
    private HashMap expressionPositions = new HashMap();
    private ArrayList expressionList = new ArrayList();

    public ExpressionCollection() {
    }

    public ExpressionCollection(Collection expressions) throws FunctionInitializeException {
        this();
        this.addAll(expressions);
    }

    public void add(Expression e) {
        if (e == null) {
            throw new NullPointerException("Expression is null");
        }
        if (this.expressionPositions.containsKey(e.getName())) {
            this.removeExpression(e);
        }
        this.privateAdd(e);
    }

    public void addAll(Collection expressions) throws FunctionInitializeException {
        if (expressions != null) {
            Iterator iterator = expressions.iterator();
            while (iterator.hasNext()) {
                Expression f = (Expression)iterator.next();
                this.add(f);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ExpressionCollection col = (ExpressionCollection)super.clone();
        col.expressionPositions = new HashMap();
        col.expressionList = new ArrayList();
        Iterator it = ((AbstractList)this.expressionList).iterator();
        while (it.hasNext()) {
            Expression ex = (Expression)it.next();
            col.privateAdd((Expression)ex.clone());
        }
        return col;
    }

    public Expression get(String name) {
        Integer position = (Integer)this.expressionPositions.get(name);
        if (position == null) {
            return null;
        }
        return this.getExpression(position);
    }

    public Expression getExpression(int pos) {
        return (Expression)this.expressionList.get(pos);
    }

    protected void privateAdd(Expression e) {
        this.expressionPositions.put(e.getName(), new Integer(this.expressionList.size()));
        this.expressionList.add(e);
    }

    public void removeExpression(Expression e) {
        Integer val = (Integer)this.expressionPositions.get(e.getName());
        if (val == null) {
            return;
        }
        this.expressionPositions.remove(e.getName());
        this.expressionList.remove(val);
    }

    public int size() {
        return this.expressionList.size();
    }
}

