/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.function.AbstractElementFormatFunction;
import org.jfree.report.function.FunctionUtilities;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.SerializerHelper;

public class ElementColorFunction
extends AbstractElementFormatFunction
implements Serializable {
    private transient Color colorTrue;
    private transient Color colorFalse;
    private String field;

    public Color getColorFalse() {
        return this.colorFalse;
    }

    public Color getColorTrue() {
        return this.colorTrue;
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return null;
    }

    protected void processRootBand(Band b) {
        Element[] elements = FunctionUtilities.findAllElements(b, this.getElement());
        if (elements.length == 0) {
            return;
        }
        Object o = this.getDataRow().get(this.getField());
        boolean value = o == null ? false : o.equals(Boolean.TRUE);
        Color color = value ? this.getColorTrue() : this.getColorFalse();
        int i = 0;
        while (i < elements.length) {
            elements[i].getStyle().setStyleProperty(ElementStyleSheet.PAINT, color);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.colorFalse = (Color)SerializerHelper.getInstance().readObject(in);
        this.colorTrue = (Color)SerializerHelper.getInstance().readObject(in);
    }

    public void setColorFalse(Color colorFalse) {
        this.colorFalse = colorFalse;
    }

    public void setColorTrue(Color colorTrue) {
        this.colorTrue = colorTrue;
    }

    public void setField(String field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this.field = field;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper.getInstance().writeObject(this.colorFalse, out);
        SerializerHelper.getInstance().writeObject(this.colorTrue, out);
    }
}

