/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.jfree.report.DataRow;
import org.jfree.report.function.AbstractExpression;

public class ConvertToNumberExpression
extends AbstractExpression {
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private String field;
    private String format;

    public String getField() {
        return this.field;
    }

    public String getFormat() {
        return this.format;
    }

    public Object getValue() {
        DataRow dataRow = this.getDataRow();
        Object o = dataRow.get(this.field);
        if (o instanceof Number) {
            return o;
        }
        if (this.format == null) {
            try {
                BigDecimal f = new BigDecimal(String.valueOf(o));
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                return ZERO;
            }
        }
        try {
            DecimalFormat format = new DecimalFormat(this.getFormat());
            return format.parse(String.valueOf(o));
        }
        catch (ParseException parseException) {
            return ZERO;
        }
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

