/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.MessageFormatSupport;
import org.jfree.report.filter.ReportConnectable;

public class MessageFormatFilter
implements ReportConnectable,
Serializable,
DataSource {
    private transient ReportDefinition reportDefinition;
    private MessageFormatSupport messageFormatSupport = new MessageFormatSupport();

    public Object clone() throws CloneNotSupportedException {
        MessageFormatFilter mf = (MessageFormatFilter)super.clone();
        mf.reportDefinition = null;
        return mf;
    }

    public String getFormatString() {
        return this.messageFormatSupport.getFormatString();
    }

    public Object getValue() {
        if (this.reportDefinition == null) {
            return null;
        }
        this.messageFormatSupport.setLocale(this.reportDefinition.getResourceBundleFactory().getLocale());
        return this.messageFormatSupport.performFormat(this.reportDefinition.getDataRow());
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            throw new IllegalStateException("Already connected.");
        }
        if (reportDefinition == null) {
            throw new NullPointerException("The given report definition is null");
        }
        this.reportDefinition = reportDefinition;
    }

    public void setFormatString(String format) {
        this.messageFormatSupport.setFormatString(format);
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != reportDefinition) {
            throw new IllegalStateException("This report definition is not registered.");
        }
        this.reportDefinition = null;
    }
}

