/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import org.jfree.report.DataRow;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.ReportConnectable;

public class DataRowDataSource
implements DataSource,
Serializable,
ReportConnectable {
    private String dataSourceColumnName;
    private transient ReportDefinition reportDefinition;

    public DataRowDataSource() {
        this.setDataSourceColumnName("");
    }

    public DataRowDataSource(String column) {
        this.setDataSourceColumnName(column);
    }

    public Object clone() throws CloneNotSupportedException {
        DataRowDataSource drs = (DataRowDataSource)super.clone();
        drs.reportDefinition = null;
        return drs;
    }

    public DataRow getDataRow() {
        if (this.reportDefinition == null) {
            return null;
        }
        return this.reportDefinition.getDataRow();
    }

    public String getDataSourceColumnName() {
        return this.dataSourceColumnName;
    }

    public Object getValue() {
        if (this.getDataRow() == null) {
            throw new IllegalStateException("No DataRowBackend Connected");
        }
        return this.getDataRow().get(this.getDataSourceColumnName());
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            throw new IllegalStateException("Already connected.");
        }
        if (reportDefinition == null) {
            throw new NullPointerException("The given report definition is null");
        }
        this.reportDefinition = reportDefinition;
    }

    public void setDataSourceColumnName(String dataSourceColumnName) {
        if (dataSourceColumnName == null) {
            throw new NullPointerException();
        }
        this.dataSourceColumnName = dataSourceColumnName;
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != reportDefinition) {
            throw new IllegalStateException("This report definition is not registered.");
        }
        this.reportDefinition = null;
    }
}

