/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ShapeElement;
import org.jfree.report.elementfactory.ShapeElementFactory;
import org.jfree.report.filter.DataRowDataSource;
import org.jfree.ui.FloatDimension;

public class ShapeFieldElementFactory
extends ShapeElementFactory {
    private String fieldname;

    public Element createElement() {
        if (this.getFieldname() == null) {
            throw new IllegalStateException("Fieldname is not set.");
        }
        ShapeElement e = new ShapeElement();
        this.applyStyle(e.getStyle());
        this.applyElementName(e);
        e.setDataSource(new DataRowDataSource(this.getFieldname()));
        return e;
    }

    public static ShapeElement createShapeElement(String name, Rectangle2D bounds, Color paint, Stroke stroke, String fieldname, boolean shouldDraw, boolean shouldFill, boolean shouldScale, boolean keepAspectRatio) {
        ShapeFieldElementFactory factory = new ShapeFieldElementFactory();
        factory.setName(name);
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setColor(paint);
        factory.setKeepAspectRatio(new Boolean(keepAspectRatio));
        factory.setFieldname(fieldname);
        factory.setStroke(stroke);
        factory.setShouldDraw(new Boolean(shouldDraw));
        factory.setShouldFill(new Boolean(shouldFill));
        factory.setScale(new Boolean(shouldScale));
        return (ShapeElement)factory.createElement();
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }
}

