/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextElementFactory;
import org.jfree.report.filter.templates.ResourceLabelTemplate;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;

public class ResourceLabelElementFactory
extends TextElementFactory {
    private String resourceBase;
    private String nullString;
    private String resourceKey;

    public Element createElement() {
        if (this.getResourceKey() == null) {
            throw new IllegalStateException("ResourceKey is not set.");
        }
        ResourceLabelTemplate template = new ResourceLabelTemplate();
        template.setResourceIdentifier(this.getResourceBase());
        template.setContent(this.getResourceKey());
        template.setNullValue(this.getNullString());
        TextElement element = new TextElement();
        this.applyElementName(element);
        element.setDataSource(template);
        this.applyStyle(element.getStyle());
        return element;
    }

    public static TextElement createResourceLabel(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullValue, String resourceBase, String resourceKey) {
        ResourceLabelElementFactory factory = new ResourceLabelElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setNullString(nullValue);
        factory.setResourceBase(resourceBase);
        factory.setResourceKey(resourceKey);
        return (TextElement)factory.createElement();
    }

    public String getNullString() {
        return this.nullString;
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }
}

