/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.jfree.report.Element;
import org.jfree.report.style.ElementDefaultStyleSheet;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleKey;

public class ShapeElement
extends Element {
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(0.5f);
    public static final StyleKey FILL_SHAPE = StyleKey.getStyleKey("fill-shape", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ShapeElement.class$("java.lang.Boolean")));
    public static final StyleKey DRAW_SHAPE = StyleKey.getStyleKey("draw-shape", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ShapeElement.class$("java.lang.Boolean")));
    private static ElementDefaultStyleSheet defaultShapeStyle;
    public static final String CONTENT_TYPE = "shape/generic";
    static /* synthetic */ Class class$java$lang$Boolean;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected ElementDefaultStyleSheet createGlobalDefaultStyle() {
        return ShapeElement.getDefaultStyle();
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public static synchronized ElementDefaultStyleSheet getDefaultStyle() {
        if (defaultShapeStyle == null) {
            defaultShapeStyle = new ShapeElementDefaultStyleSheet();
        }
        return defaultShapeStyle;
    }

    public Stroke getStroke() {
        return (Stroke)this.getStyle().getStyleProperty(ElementStyleSheet.STROKE);
    }

    public boolean isKeepAspectRatio() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleSheet.KEEP_ASPECT_RATIO);
    }

    public boolean isScale() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleSheet.SCALE);
    }

    public boolean isShouldDraw() {
        return this.getStyle().getBooleanStyleProperty(DRAW_SHAPE);
    }

    public boolean isShouldFill() {
        return this.getStyle().getBooleanStyleProperty(FILL_SHAPE);
    }

    public void setKeepAspectRatio(boolean kar) {
        this.getStyle().setStyleProperty(ElementStyleSheet.KEEP_ASPECT_RATIO, kar ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setScale(boolean scale) {
        this.getStyle().setStyleProperty(ElementStyleSheet.SCALE, scale ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setShouldDraw(boolean shouldDraw) {
        this.getStyle().setStyleProperty(DRAW_SHAPE, shouldDraw ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setShouldFill(boolean shouldFill) {
        this.getStyle().setStyleProperty(FILL_SHAPE, shouldFill ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStroke(Stroke stroke) {
        this.getStyle().setStyleProperty(ElementStyleSheet.STROKE, stroke);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Shape={ name=");
        b.append(this.getName());
        b.append(", shape=");
        b.append(this.getValue());
        b.append("}");
        return b.toString();
    }

    private static class ShapeElementDefaultStyleSheet
    extends ElementDefaultStyleSheet {
        public ShapeElementDefaultStyleSheet() {
            super("GlobalShapeElementDefault");
            this.setLocked(false);
            this.setStyleProperty(ElementStyleSheet.STROKE, DEFAULT_STROKE);
            this.setBooleanStyleProperty(FILL_SHAPE, false);
            this.setBooleanStyleProperty(DRAW_SHAPE, false);
            this.setLocked(true);
        }
    }
}

