/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import org.jfree.base.AbstractBoot;
import org.jfree.base.BootableProjectInfo;
import org.jfree.base.modules.PackageManager;
import org.jfree.report.JFreeReportInfo;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.util.Configuration;

public class JFreeReportBoot
extends AbstractBoot {
    private static JFreeReportBoot instance;
    private BootableProjectInfo projectInfo = new JFreeReportInfo();
    static /* synthetic */ Class class$org$jfree$report$JFreeReportCoreModule;
    static /* synthetic */ Class class$org$jfree$report$DefaultLogModule;

    private JFreeReportBoot() {
    }

    private void bootAdditionalModules() {
        try {
            String bootModules = ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.boot.Modules");
            if (bootModules != null) {
                CSVTokenizer csvToken = new CSVTokenizer(bootModules, ",");
                while (csvToken.hasMoreTokens()) {
                    String token = csvToken.nextToken();
                    this.getPackageManager().load(token);
                }
            }
        }
        catch (SecurityException securityException) {
            Log.info("Security settings forbid to check the system properties for extension modules.");
        }
        catch (Exception se) {
            Log.error("An error occured while checking the system properties for extension modules.", se);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static synchronized JFreeReportBoot getInstance() {
        if (instance == null) {
            instance = new JFreeReportBoot();
        }
        return instance;
    }

    protected BootableProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    private static boolean isStrictFP() {
        double d = 8.0E307;
        double result1 = Double.POSITIVE_INFINITY;
        double result2 = 1.6E308;
        return true;
    }

    protected Configuration loadConfiguration() {
        return ReportConfiguration.getGlobalConfig();
    }

    protected void performBoot() {
        if (!JFreeReportBoot.isStrictFP()) {
            Log.warn("The used VM seems to use a non-strict floating point arithmetics");
            Log.warn("Layouts computed with this Java Virtual Maschine may be invalid.");
            Log.warn("JFreeReport and the library 'iText' depend on the strict floating point rules");
            Log.warn("of Java1.1 as implemented by the Sun Virtual Maschines.");
            Log.warn("If you are using the BEA JRockit VM, start the Java VM with the option");
            Log.warn("'-Xstrictfp' to restore the default behaviour.");
        }
        PackageManager mgr = this.getPackageManager();
        mgr.addModule((class$org$jfree$report$JFreeReportCoreModule != null ? class$org$jfree$report$JFreeReportCoreModule : (class$org$jfree$report$JFreeReportCoreModule = JFreeReportBoot.class$("org.jfree.report.JFreeReportCoreModule"))).getName());
        mgr.addModule((class$org$jfree$report$DefaultLogModule != null ? class$org$jfree$report$DefaultLogModule : (class$org$jfree$report$DefaultLogModule = JFreeReportBoot.class$("org.jfree.report.DefaultLogModule"))).getName());
        mgr.load("org.jfree.report.modules.");
        mgr.load("org.jfree.report.ext.modules.");
        this.bootAdditionalModules();
        mgr.initializeModules();
    }
}

