/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.awt.geom.Dimension2D;
import java.io.Serializable;
import org.jfree.report.Band;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.DataTarget;
import org.jfree.report.filter.EmptyDataSource;
import org.jfree.report.filter.ReportConnectable;
import org.jfree.report.style.ElementDefaultStyleSheet;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleSheetCarrier;
import org.jfree.report.util.InstanceID;

public abstract class Element
implements DataTarget,
Serializable,
Cloneable {
    public static final String ANONYMOUS_ELEMENT_PREFIX = "anonymousElement@";
    private static final DataSource NULL_DATASOURCE = new EmptyDataSource();
    private DataSource datasource;
    private String name;
    private InternalElementStyleSheet style;
    private Band parent;
    private final InstanceID treeLock;
    private ReportDefinition reportDefinition;

    protected Element() {
        this.setName(ANONYMOUS_ELEMENT_PREFIX + System.identityHashCode(this));
        this.treeLock = new InstanceID();
        this.datasource = NULL_DATASOURCE;
        this.style = new InternalElementStyleSheet(this);
    }

    public Object clone() throws CloneNotSupportedException {
        Element e = (Element)super.clone();
        e.style = (InternalElementStyleSheet)this.style.getCopy();
        e.datasource = (DataSource)this.datasource.clone();
        e.parent = null;
        e.style.updateElementReference(e);
        e.reportDefinition = null;
        return e;
    }

    protected final void connectDataSource(DataSource ds) {
        if (this.reportDefinition == null) {
            return;
        }
        if (ds instanceof ReportConnectable) {
            ReportConnectable rc = (ReportConnectable)((Object)ds);
            rc.registerReportDefinition(this.reportDefinition);
        }
        if (ds instanceof DataTarget) {
            DataTarget dt = (DataTarget)((Object)ds);
            this.connectDataSource(dt.getDataSource());
        }
    }

    protected ElementDefaultStyleSheet createGlobalDefaultStyle() {
        return ElementDefaultStyleSheet.getDefaultStyle();
    }

    protected final void disconnectDataSource(DataSource ds) {
        if (this.reportDefinition == null) {
            return;
        }
        if (ds instanceof ReportConnectable) {
            ReportConnectable rc = (ReportConnectable)((Object)ds);
            rc.unregisterReportDefinition(this.reportDefinition);
        }
        if (ds instanceof DataTarget) {
            DataTarget dt = (DataTarget)((Object)ds);
            this.disconnectDataSource(dt.getDataSource());
        }
    }

    public abstract String getContentType();

    public final DataSource getDataSource() {
        return this.datasource;
    }

    public String getHRefTarget() {
        return (String)this.getStyle().getStyleProperty(ElementStyleSheet.HREF_TARGET);
    }

    public Dimension2D getMaximumSize() {
        return (Dimension2D)this.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
    }

    public Dimension2D getMinimumSize() {
        return (Dimension2D)this.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
    }

    public String getName() {
        return this.name;
    }

    public final Object getObjectID() {
        return this.treeLock;
    }

    public final Band getParent() {
        return this.parent;
    }

    public Dimension2D getPreferredSize() {
        return (Dimension2D)this.getStyle().getStyleProperty(ElementStyleSheet.PREFERREDSIZE);
    }

    public ReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    public ElementStyleSheet getStyle() {
        return this.style;
    }

    public final Object getTreeLock() {
        if (this.getParent() != null) {
            return this.getParent().getTreeLock();
        }
        return this.treeLock;
    }

    public Object getValue() {
        DataSource ds = this.getDataSource();
        return ds.getValue();
    }

    public boolean isDynamicContent() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleSheet.DYNAMIC_HEIGHT);
    }

    public boolean isLayoutCacheable() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE);
    }

    public boolean isVisible() {
        Boolean b = (Boolean)this.getStyle().getStyleProperty(ElementStyleSheet.VISIBLE, Boolean.FALSE);
        return b;
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException("Element.setDataSource(...) : null data source.");
        }
        this.disconnectDataSource(this.datasource);
        this.datasource = ds;
        this.connectDataSource(this.datasource);
    }

    public void setDynamicContent(boolean dynamicContent) {
        this.getStyle().setBooleanStyleProperty(ElementStyleSheet.DYNAMIC_HEIGHT, dynamicContent);
        if (dynamicContent) {
            this.setLayoutCacheable(false);
        }
    }

    public void setHRefTarget(String target) {
        this.getStyle().setStyleProperty(ElementStyleSheet.HREF_TARGET, target);
    }

    public void setLayoutCacheable(boolean layoutCacheable) {
        this.getStyle().setBooleanStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE, layoutCacheable);
    }

    public void setMaximumSize(Dimension2D maximumSize) {
        this.getStyle().setStyleProperty(ElementStyleSheet.MAXIMUMSIZE, maximumSize);
    }

    public void setMinimumSize(Dimension2D minimumSize) {
        this.getStyle().setStyleProperty(ElementStyleSheet.MINIMUMSIZE, minimumSize);
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Element.setName(...): name is null.");
        }
        this.name = name;
    }

    protected final void setParent(Band parent) {
        this.parent = parent;
        if (this.parent == null) {
            this.setReportDefinition(null);
        } else {
            this.setReportDefinition(parent.getReportDefinition());
        }
        this.style.parentChanged();
    }

    public void setPreferredSize(Dimension2D preferredSize) {
        this.getStyle().setStyleProperty(ElementStyleSheet.PREFERREDSIZE, preferredSize);
    }

    protected void setReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            this.disconnectDataSource(this.getDataSource());
        }
        this.reportDefinition = reportDefinition;
        if (this.reportDefinition != null) {
            this.connectDataSource(this.getDataSource());
        }
    }

    public void setVisible(boolean b) {
        this.getStyle().setStyleProperty(ElementStyleSheet.VISIBLE, b ? Boolean.TRUE : Boolean.FALSE);
    }

    private static class InternalElementStyleSheetCarrier
    implements StyleSheetCarrier {
        private transient ElementStyleSheet styleSheet;
        private InternalElementStyleSheet self;
        private InstanceID styleSheetID;

        public InternalElementStyleSheetCarrier(InternalElementStyleSheet parent, ElementStyleSheet styleSheet) {
            if (parent == null) {
                throw new NullPointerException("Internal stylesheet must not be null.");
            }
            if (styleSheet == null) {
                throw new NullPointerException("Inherited stylesheet must not be null.");
            }
            this.self = parent;
            this.styleSheet = styleSheet;
            this.styleSheetID = styleSheet.getId();
        }

        public Object clone() throws CloneNotSupportedException {
            InternalElementStyleSheetCarrier ic = (InternalElementStyleSheetCarrier)super.clone();
            ic.self = null;
            ic.styleSheet = null;
            return ic;
        }

        public ElementStyleSheet getStyleSheet() {
            if (this.styleSheet != null) {
                return this.styleSheet;
            }
            if (this.self == null) {
                throw new IllegalStateException("Stylesheet was not valid after restore operation.");
            }
            Element element = this.self.getElement();
            if (element == null) {
                throw new IllegalStateException();
            }
            ReportDefinition reportDefinition = element.getReportDefinition();
            if (reportDefinition == null) {
                throw new IllegalStateException("Stylesheet was not valid after restore operation.");
            }
            this.styleSheet = reportDefinition.getStyleSheetCollection().getStyleSheetByID(this.styleSheetID);
            return this.styleSheet;
        }

        public void invalidate() {
            this.styleSheet = null;
        }

        public boolean isSame(ElementStyleSheet style) {
            return style.getId().equals(this.styleSheetID);
        }

        protected void updateParentReference(InternalElementStyleSheet self) {
            if (self == null) {
                throw new NullPointerException("Invalid implementation: Self reference cannot be null after cloning.");
            }
            this.self = self;
        }
    }

    private static class InternalElementStyleSheet
    extends ElementStyleSheet {
        private Element element;
        private Band parent;

        public InternalElementStyleSheet(Element element) {
            super(element.getName());
            this.parent = element.getParent();
            this.element = element;
            this.setDefaultStyleSheet(element.createGlobalDefaultStyle());
            this.setAllowCaching(true);
        }

        public Object clone() throws CloneNotSupportedException {
            InternalElementStyleSheet es = (InternalElementStyleSheet)super.clone();
            es.parent = null;
            es.element = null;
            StyleSheetCarrier[] sheets = es.getParentReferences();
            int i = 0;
            while (i < sheets.length) {
                InternalElementStyleSheetCarrier esc = (InternalElementStyleSheetCarrier)sheets[i];
                esc.updateParentReference(es);
                ++i;
            }
            return es;
        }

        protected StyleSheetCarrier createCarrier(ElementStyleSheet styleSheet) {
            return new InternalElementStyleSheetCarrier(this, styleSheet);
        }

        public Element getElement() {
            return this.element;
        }

        public void parentChanged() {
            if (this.parent != null) {
                this.setCascadeStyleSheet(null);
            }
            this.parent = this.element.getParent();
            if (this.parent != null) {
                this.setCascadeStyleSheet(this.parent.getStyle());
            }
        }

        protected void updateElementReference(Element e) {
            if (e == null) {
                throw new NullPointerException("Invalid implementation: Self reference cannot be null after cloning.");
            }
            this.element = e;
        }
    }
}

