/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.swt;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import javax.swing.JPanel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;

public class SWTUtils {
    private static final String Az = "ABCpqr";

    public static FontData toSwtFontData(Device device, Font font, boolean ensureSameSize) {
        FontData fontData = new FontData();
        fontData.setName(font.getFamily());
        int style = 0;
        switch (font.getStyle()) {
            case 0: {
                style |= 0;
                break;
            }
            case 1: {
                style |= 1;
                break;
            }
            case 2: {
                style |= 2;
                break;
            }
            case 3: {
                style |= 3;
            }
        }
        fontData.setStyle(style);
        int height = (int)Math.round((double)font.getSize() * 72.0 / (double)device.getDPI().y);
        fontData.setHeight(height);
        if (ensureSameSize) {
            GC tmpGC = new GC((Drawable)device);
            JPanel DUMMY_PANEL = new JPanel();
            org.eclipse.swt.graphics.Font tmpFont = new org.eclipse.swt.graphics.Font(device, fontData);
            tmpGC.setFont(tmpFont);
            if (tmpGC.textExtent((String)Az).x > DUMMY_PANEL.getFontMetrics(font).stringWidth(Az)) {
                while (tmpGC.textExtent((String)Az).x > DUMMY_PANEL.getFontMetrics(font).stringWidth(Az)) {
                    tmpFont.dispose();
                    fontData.setHeight(--height);
                    tmpFont = new org.eclipse.swt.graphics.Font(device, fontData);
                    tmpGC.setFont(tmpFont);
                }
            } else if (tmpGC.textExtent((String)Az).x < DUMMY_PANEL.getFontMetrics(font).stringWidth(Az)) {
                while (tmpGC.textExtent((String)Az).x < DUMMY_PANEL.getFontMetrics(font).stringWidth(Az)) {
                    tmpFont.dispose();
                    fontData.setHeight(++height);
                    tmpFont = new org.eclipse.swt.graphics.Font(device, fontData);
                    tmpGC.setFont(tmpFont);
                }
            }
            tmpFont.dispose();
            tmpGC.dispose();
        }
        return fontData;
    }

    public static Font toAwtFont(Device device, FontData fontData, boolean ensureSameSize) {
        int style;
        switch (fontData.getStyle()) {
            case 0: {
                style = 0;
                break;
            }
            case 2: {
                style = 2;
                break;
            }
            case 1: {
                style = 1;
                break;
            }
            default: {
                style = 0;
            }
        }
        int height = (int)Math.round((double)(fontData.height * device.getDPI().y) / 72.0);
        if (ensureSameSize) {
            GC tmpGC = new GC((Drawable)device);
            org.eclipse.swt.graphics.Font tmpFont = new org.eclipse.swt.graphics.Font(device, fontData);
            tmpGC.setFont(tmpFont);
            JPanel DUMMY_PANEL = new JPanel();
            Font tmpAwtFont = new Font(fontData.getName(), style, height);
            if (DUMMY_PANEL.getFontMetrics(tmpAwtFont).stringWidth(Az) > tmpGC.textExtent((String)Az).x) {
                while (DUMMY_PANEL.getFontMetrics(tmpAwtFont).stringWidth(Az) > tmpGC.textExtent((String)Az).x) {
                    tmpAwtFont = new Font(fontData.getName(), style, --height);
                }
            } else if (DUMMY_PANEL.getFontMetrics(tmpAwtFont).stringWidth(Az) < tmpGC.textExtent((String)Az).x) {
                while (DUMMY_PANEL.getFontMetrics(tmpAwtFont).stringWidth(Az) < tmpGC.textExtent((String)Az).x) {
                    tmpAwtFont = new Font(fontData.getName(), style, ++height);
                }
            }
            tmpFont.dispose();
            tmpGC.dispose();
        }
        return new Font(fontData.getName(), style, height);
    }

    public static Font toAwtFont(Device device, org.eclipse.swt.graphics.Font font) {
        FontData fontData = font.getFontData()[0];
        return SWTUtils.toAwtFont(device, fontData, true);
    }

    public static Color toAwtColor(org.eclipse.swt.graphics.Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static org.eclipse.swt.graphics.Color toSwtColor(Device device, Paint paint) {
        Color color;
        if (paint instanceof Color) {
            color = (Color)paint;
        } else {
            try {
                throw new Exception("only color is supported at present... setting paint to uniform black color");
            }
            catch (Exception e) {
                e.printStackTrace();
                color = new Color(0, 0, 0);
            }
        }
        return new org.eclipse.swt.graphics.Color(device, color.getRed(), color.getGreen(), color.getBlue());
    }

    public static org.eclipse.swt.graphics.Color toSwtColor(Device device, Color color) {
        return new org.eclipse.swt.graphics.Color(device, color.getRed(), color.getGreen(), color.getBlue());
    }
}

