/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.swt;

import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.JPanel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.jfree.experimental.swt.SWTUtils;

public class SWTGraphics2D
extends Graphics2D {
    private GC gc;
    private static final JPanel DUMMY_PANEL = new JPanel();

    public SWTGraphics2D(GC gc) {
        this.gc = gc;
    }

    private void switchColors() {
        Color bg = this.gc.getBackground();
        Color fg = this.gc.getForeground();
        this.gc.setBackground(fg);
        this.gc.setForeground(bg);
    }

    private Path toSwtPath(Shape shape) {
        float[] coords = new float[6];
        Path path = new Path(this.gc.getDevice());
        PathIterator pit = shape.getPathIterator(null);
        while (!pit.isDone()) {
            int type = pit.currentSegment(coords);
            switch (type) {
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    path.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    path.close();
                    break;
                }
            }
            pit.next();
        }
        return path;
    }

    private Transform toSwtTransform(AffineTransform awtTransform) {
        Transform t = new Transform(this.gc.getDevice());
        double[] matrix = new double[6];
        awtTransform.getMatrix(matrix);
        t.setElements((float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5]);
        return t;
    }

    private AffineTransform toAwtTransform(Transform swtTransform) {
        float[] elements = new float[6];
        swtTransform.getElements(elements);
        AffineTransform awtTransform = new AffineTransform(elements);
        return awtTransform;
    }

    public void draw(Shape shape) {
        Path path = this.toSwtPath(shape);
        this.gc.drawPath(path);
        path.dispose();
    }

    public boolean drawImage(Image image, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        org.eclipse.swt.graphics.Image im = new org.eclipse.swt.graphics.Image(this.gc.getDevice(), SWTGraphics2D.convertToSWT(image));
        this.gc.drawImage(im, x, y);
        im.dispose();
    }

    public void drawImage(org.eclipse.swt.graphics.Image image, int x, int y) {
        this.gc.drawImage(image, x, y);
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
    }

    public void drawString(String text, int x, int y) {
        float fm = this.gc.getFontMetrics().getAscent();
        this.gc.drawString(text, x, (int)((float)y - fm), true);
    }

    public void drawString(String text, float x, float y) {
        float fm = this.gc.getFontMetrics().getAscent();
        this.gc.drawString(text, (int)x, (int)(y - fm), true);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
    }

    public void fill(Shape shape) {
        Path path = this.toSwtPath(shape);
        this.switchColors();
        this.gc.fillPath(path);
        this.switchColors();
        path.dispose();
    }

    public boolean hit(Rectangle rect, Shape text, boolean onStroke) {
        return false;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setComposite(Composite comp) {
    }

    public void setPaint(Paint paint) {
        if (!(paint instanceof java.awt.Color)) {
            throw new RuntimeException("Can only handle 'Color' at present.");
        }
        this.setColor((java.awt.Color)paint);
    }

    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            this.gc.setLineWidth((int)bs.getLineWidth());
            switch (bs.getLineJoin()) {
                case 2: {
                    this.gc.setLineJoin(3);
                    break;
                }
                case 0: {
                    this.gc.setLineJoin(1);
                    break;
                }
                case 1: {
                    this.gc.setLineJoin(2);
                }
            }
            switch (bs.getEndCap()) {
                case 0: {
                    this.gc.setLineCap(1);
                    break;
                }
                case 1: {
                    this.gc.setLineCap(2);
                    break;
                }
                case 2: {
                    this.gc.setLineCap(3);
                }
            }
            this.gc.setLineStyle(1);
            float[] dashes = bs.getDashArray();
            if (dashes != null) {
                int[] swtDashes = new int[dashes.length];
                for (int i = 0; i < swtDashes.length; ++i) {
                    swtDashes[i] = (int)dashes[i];
                }
                this.gc.setLineDash(swtDashes);
            }
        } else {
            throw new RuntimeException("Can only handle 'Basic Stroke' at present.");
        }
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public void translate(int x, int y) {
        Transform swtTransform = new Transform(this.gc.getDevice());
        this.gc.getTransform(swtTransform);
        swtTransform.translate((float)x, (float)y);
        this.gc.setTransform(swtTransform);
        swtTransform.dispose();
    }

    public void translate(double tx, double ty) {
        this.translate((int)tx, (int)ty);
    }

    public void rotate(double theta) {
        Transform swtTransform = new Transform(this.gc.getDevice());
        this.gc.getTransform(swtTransform);
        swtTransform.rotate((float)(theta * 180.0 / Math.PI));
        this.gc.setTransform(swtTransform);
        swtTransform.dispose();
    }

    public void rotate(double theta, double x, double y) {
    }

    public void scale(double scaleX, double scaleY) {
        Transform swtTransform = new Transform(this.gc.getDevice());
        this.gc.getTransform(swtTransform);
        swtTransform.scale((float)scaleX, (float)scaleY);
        this.gc.setTransform(swtTransform);
        swtTransform.dispose();
    }

    public void shear(double shearX, double shearY) {
        Transform swtTransform = new Transform(this.gc.getDevice());
        this.gc.getTransform(swtTransform);
        Transform shear = new Transform(this.gc.getDevice(), 1.0f, (float)shearX, (float)shearY, 1.0f, 0.0f, 0.0f);
        swtTransform.multiply(shear);
        this.gc.setTransform(swtTransform);
        swtTransform.dispose();
    }

    public void transform(AffineTransform Tx) {
        Transform swtTransform = new Transform(this.gc.getDevice());
        this.gc.getTransform(swtTransform);
        swtTransform.multiply(this.toSwtTransform(Tx));
        this.gc.setTransform(swtTransform);
        swtTransform.dispose();
    }

    public void setTransform(AffineTransform Tx) {
        this.gc.setTransform(this.toSwtTransform(Tx));
    }

    public AffineTransform getTransform() {
        Transform swtTransform = new Transform(this.gc.getDevice());
        this.gc.getTransform(swtTransform);
        return this.toAwtTransform(swtTransform);
    }

    public Paint getPaint() {
        return SWTUtils.toAwtColor(this.gc.getForeground());
    }

    public Composite getComposite() {
        return null;
    }

    public void setBackground(java.awt.Color color) {
        this.gc.setBackground(SWTUtils.toSwtColor(this.gc.getDevice(), color));
    }

    public java.awt.Color getBackground() {
        return SWTUtils.toAwtColor(this.gc.getBackground());
    }

    public Stroke getStroke() {
        return new BasicStroke(this.gc.getLineWidth(), this.gc.getLineCap(), this.gc.getLineJoin());
    }

    public void clip(Shape s) {
        Path path = this.toSwtPath(s);
        this.gc.setClipping(path);
        path.dispose();
    }

    public FontRenderContext getFontRenderContext() {
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        return fontRenderContext;
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    public Graphics create() {
        return null;
    }

    public java.awt.Color getColor() {
        return SWTUtils.toAwtColor(this.gc.getForeground());
    }

    public void setColor(java.awt.Color color) {
        this.gc.setForeground(SWTUtils.toSwtColor(this.gc.getDevice(), color));
    }

    public void setPaintMode() {
    }

    public void setXORMode(java.awt.Color color) {
    }

    public Font getFont() {
        FontData[] fontData = this.gc.getFont().getFontData();
        return SWTUtils.toAwtFont(this.gc.getDevice(), fontData[0], true);
    }

    public void setFont(Font font) {
        org.eclipse.swt.graphics.Font swtFont = new org.eclipse.swt.graphics.Font(this.gc.getDevice(), SWTUtils.toSwtFontData(this.gc.getDevice(), font, true));
        this.gc.setFont(swtFont);
    }

    public FontMetrics getFontMetrics(Font font) {
        return DUMMY_PANEL.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        org.eclipse.swt.graphics.Rectangle clip = this.gc.getClipping();
        return new Rectangle(clip.x, clip.y, clip.width, clip.height);
    }

    public void clipRect(int x, int y, int width, int height) {
        org.eclipse.swt.graphics.Rectangle clip = this.gc.getClipping();
        clip.intersects(x, y, width, height);
        this.gc.setClipping(clip);
    }

    public void setClip(int x, int y, int width, int height) {
        this.gc.setClipping(x, y, width, height);
    }

    public Shape getClip() {
        return null;
    }

    public void setClip(Shape clip) {
        if (clip == null) {
            return;
        }
        Path clipPath = this.toSwtPath(clip);
        this.gc.setClipping(clipPath);
        clipPath.dispose();
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1, y1, x2, y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.gc.fillRectangle(x, y, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public void drawOval(int x, int y, int width, int height) {
    }

    public void fillOval(int x, int y, int width, int height) {
    }

    public void drawArc(int x, int y, int width, int height, int arcStart, int arcAngle) {
    }

    public void fillArc(int x, int y, int width, int height, int arcStart, int arcAngle) {
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int npoints) {
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int npoints) {
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int npoints) {
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image image, int x, int y, java.awt.Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, java.awt.Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, java.awt.Color bgcolor, ImageObserver observer) {
        return false;
    }

    public void dispose() {
        this.gc.dispose();
    }

    static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                }
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            for (int i = 0; i < rgbs.length; ++i) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                }
            }
            return data;
        }
        return null;
    }
}

