/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tracker;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.experimental.chart.swt.editor.SWTChartEditor;
import org.jfree.experimental.swt.SWTGraphics2D;

public class ChartComposite
extends Composite
implements ChartChangeListener,
ChartProgressListener,
SelectionListener,
Printable {
    public static final boolean DEFAULT_BUFFER_USED = false;
    public static final int DEFAULT_WIDTH = 680;
    public static final int DEFAULT_HEIGHT = 420;
    public static final int DEFAULT_MINIMUM_DRAW_WIDTH = 300;
    public static final int DEFAULT_MINIMUM_DRAW_HEIGHT = 200;
    public static final int DEFAULT_MAXIMUM_DRAW_WIDTH = 1000;
    public static final int DEFAULT_MAXIMUM_DRAW_HEIGHT = 1000;
    public static final int DEFAULT_ZOOM_TRIGGER_DISTANCE = 10;
    public static final String PROPERTIES_COMMAND = "PROPERTIES";
    public static final String SAVE_COMMAND = "SAVE";
    public static final String PRINT_COMMAND = "PRINT";
    public static final String ZOOM_IN_BOTH_COMMAND = "ZOOM_IN_BOTH";
    public static final String ZOOM_IN_DOMAIN_COMMAND = "ZOOM_IN_DOMAIN";
    public static final String ZOOM_IN_RANGE_COMMAND = "ZOOM_IN_RANGE";
    public static final String ZOOM_OUT_BOTH_COMMAND = "ZOOM_OUT_BOTH";
    public static final String ZOOM_OUT_DOMAIN_COMMAND = "ZOOM_DOMAIN_BOTH";
    public static final String ZOOM_OUT_RANGE_COMMAND = "ZOOM_RANGE_BOTH";
    public static final String ZOOM_RESET_BOTH_COMMAND = "ZOOM_RESET_BOTH";
    public static final String ZOOM_RESET_DOMAIN_COMMAND = "ZOOM_RESET_DOMAIN";
    public static final String ZOOM_RESET_RANGE_COMMAND = "ZOOM_RESET_RANGE";
    public JFreeChart chart;
    private Canvas canvas;
    private EventListenerList chartMouseListeners;
    private boolean useBuffer;
    private boolean refreshBuffer;
    private Image chartBuffer;
    private int chartBufferHeight;
    private int chartBufferWidth;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private Menu popup;
    private ChartRenderingInfo info;
    private Point2D anchor;
    private double scaleX;
    private double scaleY;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private boolean domainZoomable = false;
    private boolean rangeZoomable = false;
    private Point zoomPoint = null;
    private transient Rectangle2D zoomRectangle = null;
    private int zoomTriggerDistance;
    private MenuItem zoomInBothMenuItem;
    private MenuItem zoomInDomainMenuItem;
    private MenuItem zoomInRangeMenuItem;
    private MenuItem zoomOutBothMenuItem;
    private MenuItem zoomOutDomainMenuItem;
    private MenuItem zoomOutRangeMenuItem;
    private MenuItem zoomResetBothMenuItem;
    private MenuItem zoomResetDomainMenuItem;
    private MenuItem zoomResetRangeMenuItem;
    private boolean enforceFileExtensions;
    private double zoomInFactor = 0.5;
    private double zoomOutFactor = 2.0;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.LocalizationBundle");
    static /* synthetic */ Class class$org$jfree$chart$ChartMouseListener;

    public ChartComposite(Composite comp, int style) {
        this(comp, style, null, 680, 420, 300, 200, 1000, 1000, false, true, true, true, true, true);
    }

    public ChartComposite(Composite comp, int style, JFreeChart chart) {
        this(comp, style, chart, 680, 420, 300, 200, 1000, 1000, false, true, true, true, true, true);
    }

    public ChartComposite(Composite comp, int style, JFreeChart chart, boolean useBuffer) {
        this(comp, style, chart, 680, 420, 300, 200, 1000, 1000, useBuffer, true, true, true, true, true);
    }

    public ChartComposite(Composite comp, int style, JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this(comp, style, chart, 680, 420, 300, 200, 1000, 1000, false, properties, save, print, zoom, tooltips);
    }

    public ChartComposite(Composite comp, int style, JFreeChart jfreechart, int width, int height, int minimumDrawW, int minimumDrawH, int maximumDrawW, int maximumDrawH, boolean usingBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(comp, style);
        this.chart = jfreechart;
        this.setLayout((Layout)new FillLayout());
        this.info = new ChartRenderingInfo();
        this.useBuffer = usingBuffer;
        this.refreshBuffer = false;
        this.minimumDrawWidth = minimumDrawW;
        this.minimumDrawHeight = minimumDrawH;
        this.maximumDrawWidth = maximumDrawW;
        this.maximumDrawHeight = maximumDrawH;
        this.zoomTriggerDistance = 10;
        this.canvas = new Canvas((Composite)this, 262144);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SWTGraphics2D sg2 = new SWTGraphics2D(e.gc);
                Rectangle available = ChartComposite.this.getBounds();
                boolean scale = false;
                int drawWidth = available.width;
                int drawHeight = available.height;
                if ((double)drawWidth == 0.0 || (double)drawHeight == 0.0) {
                    return;
                }
                ChartComposite.this.scaleX = 1.0;
                ChartComposite.this.scaleY = 1.0;
                if (drawWidth < ChartComposite.this.minimumDrawWidth) {
                    ChartComposite.this.scaleX = (double)drawWidth / (double)ChartComposite.this.minimumDrawWidth;
                    drawWidth = ChartComposite.this.minimumDrawWidth;
                    scale = true;
                } else if (drawWidth > ChartComposite.this.maximumDrawWidth) {
                    ChartComposite.this.scaleX = (double)drawWidth / (double)ChartComposite.this.maximumDrawWidth;
                    drawWidth = ChartComposite.this.maximumDrawWidth;
                    scale = true;
                }
                if (drawHeight < ChartComposite.this.minimumDrawHeight) {
                    ChartComposite.this.scaleY = (double)drawHeight / (double)ChartComposite.this.minimumDrawHeight;
                    drawHeight = ChartComposite.this.minimumDrawHeight;
                    scale = true;
                } else if (drawHeight > ChartComposite.this.maximumDrawHeight) {
                    ChartComposite.this.scaleY = (double)drawHeight / (double)ChartComposite.this.maximumDrawHeight;
                    drawHeight = ChartComposite.this.maximumDrawHeight;
                    scale = true;
                }
                if (ChartComposite.this.useBuffer) {
                    ChartComposite.this.chartBuffer = (Image)ChartComposite.this.canvas.getData("double-buffer-image");
                    if (ChartComposite.this.chartBuffer == null || ChartComposite.this.chartBufferWidth != available.width || ChartComposite.this.chartBufferHeight != available.height) {
                        ChartComposite.this.chartBufferWidth = available.width;
                        ChartComposite.this.chartBufferHeight = available.height;
                        if (ChartComposite.this.chartBuffer != null) {
                            ChartComposite.this.chartBuffer.dispose();
                        }
                        ChartComposite.this.chartBuffer = new Image((Device)ChartComposite.this.getDisplay(), ChartComposite.this.chartBufferWidth, ChartComposite.this.chartBufferHeight);
                        ChartComposite.this.refreshBuffer = true;
                    }
                    if (ChartComposite.this.refreshBuffer) {
                        if (scale) {
                            sg2.scale(ChartComposite.this.scaleX, ChartComposite.this.scaleY);
                        }
                        GC gci = new GC((Drawable)ChartComposite.this.chartBuffer);
                        SWTGraphics2D sg2d = new SWTGraphics2D(gci);
                        ChartComposite.this.chart.draw((Graphics2D)sg2d, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, ChartComposite.this.chartBufferWidth, ChartComposite.this.chartBufferHeight), ChartComposite.this.info);
                        ChartComposite.this.canvas.setData("double-buffer-image", (Object)ChartComposite.this.chartBuffer);
                        gci.dispose();
                        ChartComposite.this.refreshBuffer = false;
                    }
                    sg2.drawImage(ChartComposite.this.chartBuffer, 0, 0);
                } else {
                    ChartComposite.this.chart.draw((Graphics2D)sg2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, ChartComposite.this.getBounds().width, ChartComposite.this.getBounds().height), ChartComposite.this.info);
                }
            }
        });
        this.chartMouseListeners = new EventListenerList();
        if (this.chart != null) {
            this.chart.addChangeListener((ChartChangeListener)this);
            Plot plot = this.chart.getPlot();
            this.domainZoomable = false;
            this.rangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)plot;
                this.domainZoomable = z.isDomainZoomable();
                this.rangeZoomable = z.isRangeZoomable();
                this.orientation = z.getOrientation();
            }
        }
        this.popup = null;
        if (properties || save || print || zoom) {
            this.popup = this.createPopupMenu(properties, save, print, zoom);
        }
        Listener listener = new Listener(){

            /*
             * Unable to fully structure code
             */
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        ChartComposite.access$1302(ChartComposite.this, new Point(event.x, event.y));
                        insets = ChartComposite.this.getClientArea();
                        x = (int)((double)(event.x - insets.x) / ChartComposite.access$000(ChartComposite.this));
                        y = (int)((double)(event.y - insets.y) / ChartComposite.access$100(ChartComposite.this));
                        ChartComposite.access$1402(ChartComposite.this, new Point2D.Double(x, y));
                        ChartComposite.this.chart.setNotify(true);
                        listeners = ChartComposite.access$1500(ChartComposite.this).getListeners(ChartComposite.class$org$jfree$chart$ChartMouseListener == null ? (ChartComposite.class$org$jfree$chart$ChartMouseListener = ChartComposite.class$("org.jfree.chart.ChartMouseListener")) : ChartComposite.class$org$jfree$chart$ChartMouseListener);
                        if (listeners.length == 0) {
                            return;
                        }
                        entity = null;
                        if (ChartComposite.access$1200(ChartComposite.this) != null && (entities = ChartComposite.access$1200(ChartComposite.this).getEntityCollection()) != null) {
                            entity = entities.getEntity((double)x, (double)y);
                        }
                        chartEvent = new ChartMouseEvent(ChartComposite.this.getChart(), null, entity);
                        for (i = listeners.length - 1; i >= 0; --i) {
                            ((ChartMouseListener)listeners[i]).chartMouseClicked(chartEvent);
                        }
                        break;
                    }
                    case 5: {
                        if (ChartComposite.access$1300(ChartComposite.this) == null) {
                            return;
                        }
                        tracker = new Tracker((Composite)ChartComposite.access$800(ChartComposite.this), 16);
                        rect = new Rectangle(ChartComposite.access$1300((ChartComposite)ChartComposite.this).x, ChartComposite.access$1300((ChartComposite)ChartComposite.this).y, ChartComposite.access$1300((ChartComposite)ChartComposite.this).x - event.x, ChartComposite.access$1300((ChartComposite)ChartComposite.this).y - event.y);
                        tracker.setRectangles(new Rectangle[]{rect});
                        tracker.open();
                        trect = tracker.getRectangles()[0];
                        hZoom = false;
                        vZoom = false;
                        if (ChartComposite.access$1600(ChartComposite.this) == PlotOrientation.HORIZONTAL) {
                            hZoom = ChartComposite.access$1700(ChartComposite.this);
                            vZoom = ChartComposite.access$1800(ChartComposite.this);
                        } else {
                            hZoom = ChartComposite.access$1800(ChartComposite.this);
                            vZoom = ChartComposite.access$1700(ChartComposite.this);
                        }
                        scaledDataArea = ChartComposite.this.getScreenDataArea(ChartComposite.access$1300((ChartComposite)ChartComposite.this).x, ChartComposite.access$1300((ChartComposite)ChartComposite.this).y);
                        if (!hZoom || !vZoom) ** GOTO lbl45
                        ChartComposite.access$1902(ChartComposite.this, new Rectangle2D.Double(trect.x, trect.y, trect.width, trect.height));
                        Rectangle2D.intersect(ChartComposite.access$1900(ChartComposite.this), scaledDataArea, ChartComposite.access$1900(ChartComposite.this));
                        ** GOTO lbl54
lbl45:
                        // 1 sources

                        if (!hZoom) ** GOTO lbl50
                        ChartComposite.access$1902(ChartComposite.this, new Rectangle2D.Double(trect.x, scaledDataArea.getMinY(), trect.width, scaledDataArea.getHeight()));
                        Rectangle2D.intersect(ChartComposite.access$1900(ChartComposite.this), scaledDataArea, ChartComposite.access$1900(ChartComposite.this));
                        ** GOTO lbl54
lbl50:
                        // 1 sources

                        if (vZoom) {
                            ChartComposite.access$1902(ChartComposite.this, new Rectangle2D.Double(scaledDataArea.getMinX(), trect.y, scaledDataArea.getWidth(), trect.height));
                            Rectangle2D.intersect(ChartComposite.access$1900(ChartComposite.this), scaledDataArea, ChartComposite.access$1900(ChartComposite.this));
                        }
                    }
lbl54:
                    // 6 sources

                    case 4: {
                        if (ChartComposite.access$1900(ChartComposite.this) == null) {
                            screenDataArea = ChartComposite.this.getScreenDataArea(event.x, event.y);
                            if (screenDataArea != null) {
                                ChartComposite.access$1302(ChartComposite.this, ChartComposite.access$2000(ChartComposite.this, event.x, event.y, screenDataArea));
                            }
                            if (ChartComposite.access$2100(ChartComposite.this) != null && event.button == 3) {
                                ChartComposite.this.displayPopupMenu(ChartComposite.access$800((ChartComposite)ChartComposite.this).getShell().getLocation().x + ChartComposite.access$800((ChartComposite)ChartComposite.this).getParent().getLocation().x + ChartComposite.access$800((ChartComposite)ChartComposite.this).getLocation().x + event.x, ChartComposite.access$800((ChartComposite)ChartComposite.this).getShell().getLocation().y + ChartComposite.access$800((ChartComposite)ChartComposite.this).getParent().getLocation().y + ChartComposite.access$800((ChartComposite)ChartComposite.this).getLocation().y + event.y);
                            }
                        } else {
                            hZoom = false;
                            vZoom = false;
                            if (ChartComposite.access$1600(ChartComposite.this) == PlotOrientation.HORIZONTAL) {
                                hZoom = ChartComposite.access$1700(ChartComposite.this);
                                vZoom = ChartComposite.access$1800(ChartComposite.this);
                            } else {
                                hZoom = ChartComposite.access$1800(ChartComposite.this);
                                vZoom = ChartComposite.access$1700(ChartComposite.this);
                            }
                            zoomTrigger1 = hZoom != false && ChartComposite.access$1900(ChartComposite.this).getWidth() >= (double)ChartComposite.access$2200(ChartComposite.this);
                            v0 = zoomTrigger2 = vZoom != false && ChartComposite.access$1900(ChartComposite.this).getHeight() >= (double)ChartComposite.access$2200(ChartComposite.this);
                            if (zoomTrigger1 || zoomTrigger2) {
                                if (hZoom != false && ChartComposite.access$1900(ChartComposite.this).getX() < (double)ChartComposite.access$1300((ChartComposite)ChartComposite.this).x || vZoom && ChartComposite.access$1900(ChartComposite.this).getY() < (double)ChartComposite.access$1300((ChartComposite)ChartComposite.this).y) {
                                    ChartComposite.this.restoreAutoBounds();
                                } else {
                                    ChartComposite.this.zoom(ChartComposite.access$1900(ChartComposite.this));
                                }
                                ChartComposite.access$800(ChartComposite.this).redraw();
                            }
                        }
                        ChartComposite.access$1302(ChartComposite.this, null);
                        ChartComposite.access$1902(ChartComposite.this, null);
                    }
                }
            }
        };
        this.canvas.addListener(3, listener);
        this.canvas.addListener(5, listener);
        this.canvas.addListener(4, listener);
        this.enforceFileExtensions = true;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public Point2D getAnchor() {
        return this.anchor;
    }

    protected void setAnchor(Point2D anchor) {
        this.anchor = anchor;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        if (this.chart != null) {
            this.chart.removeChangeListener((ChartChangeListener)this);
            this.chart.removeProgressListener((ChartProgressListener)this);
        }
        this.chart = chart;
        if (chart != null) {
            this.chart.addChangeListener((ChartChangeListener)this);
            this.chart.addProgressListener((ChartProgressListener)this);
            Plot plot = chart.getPlot();
            this.domainZoomable = false;
            this.rangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)plot;
                this.domainZoomable = z.isDomainZoomable();
                this.rangeZoomable = z.isRangeZoomable();
                this.orientation = z.getOrientation();
            }
        } else {
            this.domainZoomable = false;
            this.rangeZoomable = false;
        }
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.redraw();
    }

    public double getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(double factor) {
        this.zoomInFactor = factor;
    }

    public double getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(double factor) {
        this.zoomOutFactor = factor;
    }

    private void attemptEditChartProperties() {
        SWTChartEditor editor = new SWTChartEditor(this.canvas.getDisplay(), this.chart);
        editor.open();
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean enforce) {
        this.enforceFileExtensions = enforce;
    }

    public void doSaveAs() throws IOException {
        FileDialog fileDialog = new FileDialog(this.canvas.getShell(), 8192);
        String[] extensions = new String[]{"*.png"};
        fileDialog.setFilterExtensions(extensions);
        String filename = fileDialog.open();
        if (filename != null) {
            if (this.isEnforceFileExtensions() && !filename.endsWith(".png")) {
                filename = filename + ".png";
            }
            ChartUtilities.saveChartAsPNG((File)new File(filename), (JFreeChart)this.chart, (int)this.canvas.getSize().x, (int)this.canvas.getSize().y);
        }
    }

    private Point getPointInRectangle(int x, int y, Rectangle2D area) {
        x = (int)Math.max(Math.ceil(area.getMinX()), Math.min((double)x, Math.floor(area.getMaxX())));
        y = (int)Math.max(Math.ceil(area.getMinY()), Math.min((double)y, Math.floor(area.getMaxY())));
        return new Point(x, y);
    }

    public void zoomInBoth(double x, double y) {
        this.zoomInDomain(x, y);
        this.zoomInRange(x, y);
    }

    public void zoomInDomain(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable plot = (Zoomable)p;
            plot.zoomDomainAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)x, (int)y)));
        }
    }

    public void zoomInRange(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)p;
            z.zoomRangeAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)x, (int)y)));
        }
    }

    public void zoomOutBoth(double x, double y) {
        this.zoomOutDomain(x, y);
        this.zoomOutRange(x, y);
    }

    public void zoomOutDomain(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)p;
            z.zoomDomainAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)x, (int)y)));
        }
    }

    public void zoomOutRange(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)p;
            z.zoomRangeAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)x, (int)y)));
        }
    }

    public void zoom(Rectangle2D selection) {
        Point2D selectOrigin = this.translateScreenToJava2D(new Point((int)Math.ceil(selection.getX()), (int)Math.ceil(selection.getY())));
        PlotRenderingInfo plotInfo = this.info.getPlotInfo();
        Rectangle2D scaledDataArea = this.getScreenDataArea((int)selection.getCenterX(), (int)selection.getCenterY());
        if (selection.getHeight() > 0.0 && selection.getWidth() > 0.0) {
            double hLower = (selection.getMinX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double hUpper = (selection.getMaxX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double vLower = (scaledDataArea.getMaxY() - selection.getMaxY()) / scaledDataArea.getHeight();
            double vUpper = (scaledDataArea.getMaxY() - selection.getMinY()) / scaledDataArea.getHeight();
            Plot p = this.chart.getPlot();
            if (p instanceof Zoomable) {
                Zoomable z = (Zoomable)p;
                if (z.getOrientation() == PlotOrientation.HORIZONTAL) {
                    z.zoomDomainAxes(vLower, vUpper, plotInfo, selectOrigin);
                    z.zoomRangeAxes(hLower, hUpper, plotInfo, selectOrigin);
                } else {
                    z.zoomDomainAxes(hLower, hUpper, plotInfo, selectOrigin);
                    z.zoomRangeAxes(vLower, vUpper, plotInfo, selectOrigin);
                }
            }
        }
    }

    public void chartChanged(ChartChangeEvent event) {
        this.refreshBuffer = true;
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)plot;
            this.orientation = z.getOrientation();
        }
        this.redraw();
    }

    public void forceRedraw() {
        Event ev = new Event();
        ev.gc = new GC((Drawable)this.canvas);
        ev.x = 0;
        ev.y = 0;
        ev.width = this.canvas.getBounds().width;
        ev.height = this.canvas.getBounds().height;
        ev.count = 0;
        this.canvas.notifyListeners(9, ev);
    }

    public void chartProgress(ChartProgressEvent event) {
    }

    public void restoreAutoBounds() {
        this.restoreAutoDomainBounds();
        this.restoreAutoRangeBounds();
    }

    public void restoreAutoDomainBounds() {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)p;
            z.zoomDomainAxes(0.0, this.info.getPlotInfo(), (Point2D)this.zoomPoint);
        }
    }

    public void restoreAutoRangeBounds() {
        Plot p = this.chart.getPlot();
        if (p instanceof ValueAxisPlot) {
            Zoomable z = (Zoomable)p;
            z.zoomRangeAxes(0.0, this.info.getPlotInfo(), (Point2D)this.zoomPoint);
        }
    }

    public Rectangle2D scale(Rectangle2D rect) {
        Rectangle insets = this.getClientArea();
        double x = rect.getX() * this.getScaleX() + (double)insets.x;
        double y = rect.getY() * this.getScaleY() + (double)insets.y;
        double w = rect.getWidth() * this.getScaleX();
        double h = rect.getHeight() * this.getScaleY();
        return new Rectangle2D.Double(x, y, w, h);
    }

    public Rectangle2D getScreenDataArea() {
        Rectangle2D dataArea = this.info.getPlotInfo().getDataArea();
        Rectangle clientArea = this.getClientArea();
        int x = (int)(dataArea.getX() * this.scaleX + (double)clientArea.x);
        int y = (int)(dataArea.getY() * this.scaleY + (double)clientArea.y);
        int w = (int)(dataArea.getWidth() * this.scaleX);
        int h = (int)(dataArea.getHeight() * this.scaleY);
        return new Rectangle2D.Double(x, y, w, h);
    }

    public Rectangle2D getScreenDataArea(int x, int y) {
        Rectangle2D result;
        PlotRenderingInfo plotInfo = this.info.getPlotInfo();
        if (plotInfo.getSubplotCount() == 0) {
            result = this.getScreenDataArea();
        } else {
            Point2D selectOrigin = this.translateScreenToJava2D(new Point(x, y));
            int subplotIndex = plotInfo.getSubplotIndex(selectOrigin);
            if (subplotIndex == -1) {
                return null;
            }
            result = this.scale(plotInfo.getSubplotInfo(subplotIndex).getDataArea());
        }
        return result;
    }

    public Point translateJava2DToScreen(Point2D java2DPoint) {
        Rectangle insets = this.getClientArea();
        int x = (int)(java2DPoint.getX() * this.scaleX + (double)insets.x);
        int y = (int)(java2DPoint.getY() * this.scaleY + (double)insets.y);
        return new Point(x, y);
    }

    public Point translateScreenToJavaSWT(Point screenPoint) {
        Rectangle insets = this.getClientArea();
        int x = (int)((double)(screenPoint.x - insets.x) / this.scaleX);
        int y = (int)((double)(screenPoint.y - insets.y) / this.scaleY);
        return new Point(x, y);
    }

    public Point2D translateScreenToJava2D(Point screenPoint) {
        Rectangle insets = this.getClientArea();
        int x = (int)((double)(screenPoint.x - insets.x) / this.scaleX);
        int y = (int)((double)(screenPoint.y - insets.y) / this.scaleY);
        return new Point2D.Double(x, y);
    }

    protected void displayPopupMenu(int x, int y) {
        if (this.popup != null) {
            Plot plot = this.chart.getPlot();
            boolean isDomainZoomable = false;
            boolean isRangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)plot;
                isDomainZoomable = z.isDomainZoomable();
                isRangeZoomable = z.isRangeZoomable();
            }
            if (this.zoomInDomainMenuItem != null) {
                this.zoomInDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomOutDomainMenuItem != null) {
                this.zoomOutDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomResetDomainMenuItem != null) {
                this.zoomResetDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomInRangeMenuItem != null) {
                this.zoomInRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomOutRangeMenuItem != null) {
                this.zoomOutRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomResetRangeMenuItem != null) {
                this.zoomResetRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomInBothMenuItem != null) {
                this.zoomInBothMenuItem.setEnabled(isDomainZoomable & isRangeZoomable);
            }
            if (this.zoomOutBothMenuItem != null) {
                this.zoomOutBothMenuItem.setEnabled(isDomainZoomable & isRangeZoomable);
            }
            if (this.zoomResetBothMenuItem != null) {
                this.zoomResetBothMenuItem.setEnabled(isDomainZoomable & isRangeZoomable);
            }
            this.popup.setLocation(x, y);
            this.popup.setVisible(true);
        }
    }

    public void createChartPrintJob() {
        PageFormat pf;
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf2 = job.pageDialog(pf = job.defaultPage());
        if (pf2 != pf) {
            job.setPrintable(this, pf2);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    MessageBox messageBox = new MessageBox(this.canvas.getShell(), 33);
                    messageBox.setMessage(e.getMessage());
                    messageBox.open();
                }
            }
        }
    }

    protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
        Menu result = new Menu((Control)this);
        boolean separator = false;
        if (properties) {
            MenuItem propertiesItem = new MenuItem(result, 8);
            propertiesItem.setText(localizationResources.getString("Properties..."));
            propertiesItem.setData((Object)PROPERTIES_COMMAND);
            propertiesItem.addSelectionListener((SelectionListener)this);
            separator = true;
        }
        if (save) {
            if (separator) {
                new MenuItem(result, 2);
                separator = false;
            }
            MenuItem saveItem = new MenuItem(result, 0);
            saveItem.setText(localizationResources.getString("Save_as..."));
            saveItem.setData((Object)SAVE_COMMAND);
            saveItem.addSelectionListener((SelectionListener)this);
            separator = true;
        }
        if (print) {
            if (separator) {
                new MenuItem(result, 2);
                separator = false;
            }
            MenuItem printItem = new MenuItem(result, 0);
            printItem.setText(localizationResources.getString("Print..."));
            printItem.setData((Object)PRINT_COMMAND);
            printItem.addSelectionListener((SelectionListener)this);
            separator = true;
        }
        if (zoom) {
            if (separator) {
                new MenuItem(result, 2);
                separator = false;
            }
            Menu zoomInMenu = new Menu(result);
            MenuItem zoomInMenuItem = new MenuItem(result, 64);
            zoomInMenuItem.setText(localizationResources.getString("Zoom_In"));
            zoomInMenuItem.setMenu(zoomInMenu);
            this.zoomInBothMenuItem = new MenuItem(zoomInMenu, 8);
            this.zoomInBothMenuItem.setText(localizationResources.getString("All_Axes"));
            this.zoomInBothMenuItem.setData((Object)ZOOM_IN_BOTH_COMMAND);
            this.zoomInBothMenuItem.addSelectionListener((SelectionListener)this);
            new MenuItem(zoomInMenu, 2);
            this.zoomInDomainMenuItem = new MenuItem(zoomInMenu, 8);
            this.zoomInDomainMenuItem.setText(localizationResources.getString("Domain_Axis"));
            this.zoomInDomainMenuItem.setData((Object)ZOOM_IN_DOMAIN_COMMAND);
            this.zoomInDomainMenuItem.addSelectionListener((SelectionListener)this);
            this.zoomInRangeMenuItem = new MenuItem(zoomInMenu, 8);
            this.zoomInRangeMenuItem.setText(localizationResources.getString("Range_Axis"));
            this.zoomInRangeMenuItem.setData((Object)ZOOM_IN_RANGE_COMMAND);
            this.zoomInRangeMenuItem.addSelectionListener((SelectionListener)this);
            Menu zoomOutMenu = new Menu(result);
            MenuItem zoomOutMenuItem = new MenuItem(result, 64);
            zoomOutMenuItem.setText(localizationResources.getString("Zoom_Out"));
            zoomOutMenuItem.setMenu(zoomOutMenu);
            this.zoomOutBothMenuItem = new MenuItem(zoomOutMenu, 8);
            this.zoomOutBothMenuItem.setText(localizationResources.getString("All_Axes"));
            this.zoomOutBothMenuItem.setData((Object)ZOOM_OUT_BOTH_COMMAND);
            this.zoomOutBothMenuItem.addSelectionListener((SelectionListener)this);
            new MenuItem(zoomOutMenu, 2);
            this.zoomOutDomainMenuItem = new MenuItem(zoomOutMenu, 8);
            this.zoomOutDomainMenuItem.setText(localizationResources.getString("Domain_Axis"));
            this.zoomOutDomainMenuItem.setData((Object)ZOOM_OUT_DOMAIN_COMMAND);
            this.zoomOutDomainMenuItem.addSelectionListener((SelectionListener)this);
            this.zoomOutRangeMenuItem = new MenuItem(zoomOutMenu, 8);
            this.zoomOutRangeMenuItem.setText(localizationResources.getString("Range_Axis"));
            this.zoomOutRangeMenuItem.setData((Object)ZOOM_OUT_RANGE_COMMAND);
            this.zoomOutRangeMenuItem.addSelectionListener((SelectionListener)this);
            Menu autoRangeMenu = new Menu(result);
            MenuItem autoRangeMenuItem = new MenuItem(result, 64);
            autoRangeMenuItem.setText(localizationResources.getString("Auto_Range"));
            autoRangeMenuItem.setMenu(autoRangeMenu);
            this.zoomResetBothMenuItem = new MenuItem(autoRangeMenu, 8);
            this.zoomResetBothMenuItem.setText(localizationResources.getString("All_Axes"));
            this.zoomResetBothMenuItem.setData((Object)ZOOM_RESET_BOTH_COMMAND);
            this.zoomResetBothMenuItem.addSelectionListener((SelectionListener)this);
            new MenuItem(autoRangeMenu, 2);
            this.zoomResetDomainMenuItem = new MenuItem(autoRangeMenu, 8);
            this.zoomResetDomainMenuItem.setText(localizationResources.getString("Domain_Axis"));
            this.zoomResetDomainMenuItem.setData((Object)ZOOM_RESET_DOMAIN_COMMAND);
            this.zoomResetDomainMenuItem.addSelectionListener((SelectionListener)this);
            this.zoomResetRangeMenuItem = new MenuItem(autoRangeMenu, 8);
            this.zoomResetRangeMenuItem.setText(localizationResources.getString("Range_Axis"));
            this.zoomResetRangeMenuItem.setData((Object)ZOOM_RESET_RANGE_COMMAND);
            this.zoomResetRangeMenuItem.addSelectionListener((SelectionListener)this);
        }
        return result;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String command = (String)((MenuItem)e.getSource()).getData();
        if (command.equals(PROPERTIES_COMMAND)) {
            this.attemptEditChartProperties();
        } else if (command.equals(SAVE_COMMAND)) {
            try {
                this.doSaveAs();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (command.equals(PRINT_COMMAND)) {
            this.createChartPrintJob();
        } else if (command.equals(ZOOM_IN_BOTH_COMMAND)) {
            this.zoomInBoth(e.x, e.y);
        } else if (command.equals(ZOOM_IN_DOMAIN_COMMAND)) {
            this.zoomInDomain(e.x, e.y);
        } else if (command.equals(ZOOM_IN_RANGE_COMMAND)) {
            this.zoomInRange(e.x, e.y);
        } else if (command.equals(ZOOM_OUT_BOTH_COMMAND)) {
            this.zoomOutBoth(e.x, e.y);
        } else if (command.equals(ZOOM_OUT_DOMAIN_COMMAND)) {
            this.zoomOutDomain(e.x, e.y);
        } else if (command.equals(ZOOM_OUT_RANGE_COMMAND)) {
            this.zoomOutRange(e.x, e.y);
        } else if (command.equals(ZOOM_RESET_BOTH_COMMAND)) {
            this.restoreAutoBounds();
        } else if (command.equals(ZOOM_RESET_DOMAIN_COMMAND)) {
            this.restoreAutoDomainBounds();
        } else if (command.equals(ZOOM_RESET_RANGE_COMMAND)) {
            this.restoreAutoRangeBounds();
        }
        this.forceRedraw();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex != 0) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Point access$1302(ChartComposite x0, Point x1) {
        x0.zoomPoint = x1;
        return x0.zoomPoint;
    }

    static /* synthetic */ Point2D access$1402(ChartComposite x0, Point2D x1) {
        x0.anchor = x1;
        return x0.anchor;
    }

    static /* synthetic */ EventListenerList access$1500(ChartComposite x0) {
        return x0.chartMouseListeners;
    }

    static /* synthetic */ Point access$1300(ChartComposite x0) {
        return x0.zoomPoint;
    }

    static /* synthetic */ PlotOrientation access$1600(ChartComposite x0) {
        return x0.orientation;
    }

    static /* synthetic */ boolean access$1700(ChartComposite x0) {
        return x0.rangeZoomable;
    }

    static /* synthetic */ boolean access$1800(ChartComposite x0) {
        return x0.domainZoomable;
    }

    static /* synthetic */ Rectangle2D access$1902(ChartComposite x0, Rectangle2D x1) {
        x0.zoomRectangle = x1;
        return x0.zoomRectangle;
    }

    static /* synthetic */ Rectangle2D access$1900(ChartComposite x0) {
        return x0.zoomRectangle;
    }

    static /* synthetic */ Point access$2000(ChartComposite x0, int x1, int x2, Rectangle2D x3) {
        return x0.getPointInRectangle(x1, x2, x3);
    }

    static /* synthetic */ Menu access$2100(ChartComposite x0) {
        return x0.popup;
    }

    static /* synthetic */ int access$2200(ChartComposite x0) {
        return x0.zoomTriggerDistance;
    }
}

