/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jsonapi;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonConfiguration;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;

public class JsonWriterImpl {
    private final JsonGenerator generator;
    private boolean writeDone;

    public JsonWriterImpl(Writer writer) {
        this.generator = Json.createGenerator(writer);
    }

    public JsonWriterImpl(Writer writer, JsonConfiguration config) {
        this.generator = Json.createGenerator(writer, config);
    }

    public JsonWriterImpl(OutputStream out) {
        this.generator = Json.createGenerator(out);
    }

    public JsonWriterImpl(OutputStream out, JsonConfiguration config) {
        this.generator = Json.createGenerator(out, config);
    }

    public JsonWriterImpl(OutputStream out, String encoding) {
        this.generator = Json.createGenerator(out, encoding);
    }

    public JsonWriterImpl(OutputStream out, String encoding, JsonConfiguration config) {
        this.generator = Json.createGenerator(out, encoding, config);
    }

    public void writeArray(JsonArray array) {
        if (this.writeDone) {
            throw new IllegalStateException("write/writeObject/writeArray/close method is already called.");
        }
        this.writeDone = true;
        try {
            JsonArrayBuilder<Closeable> builder = this.generator.beginArray();
            for (JsonValue value : array.getValues()) {
                builder.add(value);
            }
            builder.endArray().close();
        }
        catch (IOException ioe) {
            throw new JsonException(ioe);
        }
    }

    public void writeObject(JsonObject object) {
        if (this.writeDone) {
            throw new IllegalStateException("write/writeObject/writeArray/close method is already called.");
        }
        this.writeDone = true;
        try {
            JsonObjectBuilder<Closeable> builder = this.generator.beginObject();
            for (Map.Entry<String, JsonValue> e : object.getValues().entrySet()) {
                builder.add(e.getKey(), e.getValue());
            }
            builder.endObject().close();
        }
        catch (IOException ioe) {
            throw new JsonException(ioe);
        }
    }

    public void write(JsonStructure value) {
        if (value instanceof JsonArray) {
            this.writeArray((JsonArray)value);
        } else {
            this.writeObject((JsonObject)value);
        }
    }

    public void close() {
        this.writeDone = true;
        this.generator.close();
    }
}

