/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jsonapi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.glassfish.jsonapi.JsonArrayImpl;
import org.glassfish.jsonapi.JsonNumberImpl;
import org.glassfish.jsonapi.JsonObjectImpl;
import org.glassfish.jsonapi.JsonStringImpl;

public class JsonBuilderImpl {
    public JsonObjectBuilder<JsonBuilder.JsonBuildable<JsonObject>> beginObject() {
        final JsonObjectImpl objectImpl = new JsonObjectImpl();
        JsonBuilder.JsonBuildable<JsonObject> enclosing = new JsonBuilder.JsonBuildable<JsonObject>(){

            @Override
            public JsonObject build() {
                return objectImpl;
            }
        };
        return new JsonObjectBuilderImpl<JsonBuilder.JsonBuildable<JsonObject>>(enclosing, objectImpl.valueMap);
    }

    public JsonArrayBuilder<JsonBuilder.JsonBuildable<JsonArray>> beginArray() {
        final JsonArrayImpl arrayImpl = new JsonArrayImpl();
        JsonBuilder.JsonBuildable<JsonArray> enclosing = new JsonBuilder.JsonBuildable<JsonArray>(){

            @Override
            public JsonArray build() {
                return arrayImpl;
            }
        };
        return new JsonArrayBuilderImpl<JsonBuilder.JsonBuildable<JsonArray>>(enclosing, arrayImpl.valueList);
    }

    static class JsonArrayBuilderImpl<T>
    implements JsonArrayBuilder<T> {
        private final T enclosing;
        private final List<JsonValue> valueList;
        private boolean done;

        JsonArrayBuilderImpl(T enclosing, List<JsonValue> valueList) {
            this.enclosing = enclosing;
            this.valueList = valueList;
        }

        @Override
        public T endArray() {
            if (this.done) {
                throw new IllegalStateException("endArray() is already invoked.");
            }
            this.done = true;
            return this.enclosing;
        }

        @Override
        public JsonArrayBuilder<T> add(JsonValue value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endArray()");
            }
            this.valueList.add(value);
            return this;
        }

        @Override
        public JsonArrayBuilder<T> add(String value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endArray()");
            }
            this.valueList.add(new JsonStringImpl(value));
            return this;
        }

        @Override
        public JsonArrayBuilder<T> add(BigDecimal value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endArray()");
            }
            this.valueList.add(new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonArrayBuilder<T> add(BigInteger value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endArray()");
            }
            this.valueList.add(new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonArrayBuilder<T> add(int value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endArray()");
            }
            this.valueList.add(new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonArrayBuilder<T> add(long value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endArray()");
            }
            this.valueList.add(new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonArrayBuilder<T> add(double value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endArray()");
            }
            this.valueList.add(new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonArrayBuilder<T> add(boolean value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endArray()");
            }
            this.valueList.add(value ? JsonValue.TRUE : JsonValue.FALSE);
            return this;
        }

        @Override
        public JsonArrayBuilder<T> addNull() {
            if (this.done) {
                throw new IllegalStateException("addNull() cannot be called after endArray()");
            }
            this.valueList.add(JsonValue.NULL);
            return this;
        }

        @Override
        public JsonObjectBuilder<JsonArrayBuilder<T>> beginObject() {
            if (this.done) {
                throw new IllegalStateException("beginObject() cannot be called after endArray()");
            }
            JsonObjectImpl child = new JsonObjectImpl();
            this.valueList.add(child);
            return new JsonObjectBuilderImpl<JsonArrayBuilder<T>>(this, child.valueMap);
        }

        @Override
        public JsonArrayBuilder<JsonArrayBuilder<T>> beginArray() {
            if (this.done) {
                throw new IllegalStateException("beginArray() cannot be called after endArray()");
            }
            JsonArrayImpl child = new JsonArrayImpl();
            this.valueList.add(child);
            return new JsonArrayBuilderImpl<JsonArrayBuilder<T>>(this, child.valueList);
        }
    }

    private static class JsonObjectBuilderImpl<T>
    implements JsonObjectBuilder<T> {
        private final T enclosing;
        private final Map<String, JsonValue> valueMap;
        private boolean done;

        JsonObjectBuilderImpl(T enclosing, Map<String, JsonValue> valueMap) {
            this.enclosing = enclosing;
            this.valueMap = valueMap;
        }

        @Override
        public T endObject() {
            if (this.done) {
                throw new IllegalStateException("endObject() is already invoked.");
            }
            this.done = true;
            return this.enclosing;
        }

        @Override
        public JsonObjectBuilder<T> add(String name, JsonValue value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endObject()");
            }
            this.valueMap.put(name, value);
            return this;
        }

        @Override
        public JsonObjectBuilder<T> add(String name, String value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endObject()");
            }
            this.valueMap.put(name, new JsonStringImpl(value));
            return this;
        }

        @Override
        public JsonObjectBuilder<T> add(String name, BigInteger value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endObject()");
            }
            this.valueMap.put(name, new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonObjectBuilder<T> add(String name, BigDecimal value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endObject()");
            }
            this.valueMap.put(name, new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonObjectBuilder<T> add(String name, int value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endObject()");
            }
            this.valueMap.put(name, new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonObjectBuilder<T> add(String name, long value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endObject()");
            }
            this.valueMap.put(name, new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonObjectBuilder<T> add(String name, double value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endObject()");
            }
            this.valueMap.put(name, new JsonNumberImpl(value));
            return this;
        }

        @Override
        public JsonObjectBuilder<T> add(String name, boolean value) {
            if (this.done) {
                throw new IllegalStateException("add() cannot be called after endObject()");
            }
            this.valueMap.put(name, value ? JsonValue.TRUE : JsonValue.FALSE);
            return this;
        }

        @Override
        public JsonObjectBuilder<T> addNull(String name) {
            if (this.done) {
                throw new IllegalStateException("addNull() cannot be called after endObject()");
            }
            this.valueMap.put(name, JsonValue.NULL);
            return this;
        }

        @Override
        public JsonObjectBuilder<JsonObjectBuilder<T>> beginObject(String name) {
            if (this.done) {
                throw new IllegalStateException("beginObject() cannot be called after endObject()");
            }
            JsonObjectImpl child = new JsonObjectImpl();
            this.valueMap.put(name, child);
            return new JsonObjectBuilderImpl<JsonObjectBuilder<T>>(this, child.valueMap);
        }

        @Override
        public JsonArrayBuilder<JsonObjectBuilder<T>> beginArray(String name) {
            if (this.done) {
                throw new IllegalStateException("beginArray() cannot be called after endObject()");
            }
            JsonArrayImpl child = new JsonArrayImpl();
            this.valueMap.put(name, child);
            return new JsonArrayBuilderImpl<JsonObjectBuilder<T>>(this, child.valueList);
        }
    }
}

